import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import { htmlIdGenerator } from '../../../services';
import { EuiI18n } from '../../i18n';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiSelect, EuiFieldNumber, EuiFormLabel, EuiSwitch } from '../../form';
import { EuiScreenReaderOnly } from '../../accessibility';
import { RenderI18nTimeOptions } from '../super_date_picker/time_options';
import { EuiQuickSelectPanel } from '../super_date_picker/quick_select_popover/quick_select_panel';
import { jsx as ___EmotionJSX } from "@emotion/react";
var MILLISECONDS_IN_SECOND = 1000;
var MILLISECONDS_IN_MINUTE = MILLISECONDS_IN_SECOND * 60;
var MILLISECONDS_IN_HOUR = MILLISECONDS_IN_MINUTE * 60;
var fromMilliseconds = function fromMilliseconds(milliseconds, unit) {
  var round = function round(value) {
    return parseFloat(value.toFixed(2));
  };
  if (unit === 'h' || !unit && milliseconds > MILLISECONDS_IN_HOUR) {
    return {
      units: 'h',
      value: round(milliseconds / MILLISECONDS_IN_HOUR)
    };
  }
  if (unit === 'm' || !unit && milliseconds > MILLISECONDS_IN_MINUTE) {
    return {
      units: 'm',
      value: round(milliseconds / MILLISECONDS_IN_MINUTE)
    };
  }
  return {
    units: 's',
    value: round(milliseconds / MILLISECONDS_IN_SECOND)
  };
};
var toMilliseconds = function toMilliseconds(units, value) {
  switch (units) {
    case 'h':
      return Math.round(value * MILLISECONDS_IN_HOUR);
    case 'm':
      return Math.round(value * MILLISECONDS_IN_MINUTE);
    case 's':
    default:
      return Math.round(value * MILLISECONDS_IN_SECOND);
  }
};
var getMinInterval = function getMinInterval(minInterval, unit) {
  if (!minInterval) return 0;
  var _fromMilliseconds = fromMilliseconds(minInterval, unit),
    value = _fromMilliseconds.value;
  return Math.floor(value || 0);
};
export var EuiRefreshInterval = /*#__PURE__*/function (_Component) {
  function EuiRefreshInterval() {
    var _this;
    _classCallCheck(this, EuiRefreshInterval);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiRefreshInterval, [].concat(args));
    _defineProperty(_this, "state", _objectSpread(_objectSpread({}, fromMilliseconds(_this.props.refreshInterval || 0, _this.props.intervalUnits)), {}, {
      min: getMinInterval(_this.props.minInterval, _this.props.intervalUnits)
    }));
    _defineProperty(_this, "generateId", htmlIdGenerator());
    _defineProperty(_this, "refreshSelectionId", _this.generateId());
    _defineProperty(_this, "onValueChange", function (event) {
      var sanitizedValue = parseFloat(event.target.value);
      _this.setState({
        value: isNaN(sanitizedValue) ? '' : sanitizedValue
      }, _this.applyRefreshInterval);
    });
    _defineProperty(_this, "onUnitsChange", function (event) {
      var units = event.target.value;
      _this.setState({
        units: units,
        min: getMinInterval(_this.props.minInterval, units)
      }, _this.applyRefreshInterval);
    });
    _defineProperty(_this, "startRefresh", function () {
      var onRefreshChange = _this.props.onRefreshChange;
      var _this$state = _this.state,
        value = _this$state.value,
        units = _this$state.units;
      if (value !== '' && value > 0 && onRefreshChange !== undefined) {
        onRefreshChange({
          refreshInterval: toMilliseconds(units, value),
          intervalUnits: units,
          isPaused: false
        });
      }
    });
    _defineProperty(_this, "handleKeyDown", function (_ref) {
      var key = _ref.key;
      if (key === 'Enter') {
        _this.startRefresh();
      }
    });
    _defineProperty(_this, "applyRefreshInterval", function () {
      var _this$props = _this.props,
        onRefreshChange = _this$props.onRefreshChange,
        isPaused = _this$props.isPaused,
        minInterval = _this$props.minInterval;
      var _this$state2 = _this.state,
        units = _this$state2.units,
        value = _this$state2.value;
      if (value === '') {
        return;
      }
      if (!onRefreshChange) {
        return;
      }
      var refreshInterval = Math.max(toMilliseconds(units, value), minInterval || 0);
      onRefreshChange({
        refreshInterval: refreshInterval,
        intervalUnits: units,
        isPaused: refreshInterval <= 0 ? true : !!isPaused
      });
    });
    _defineProperty(_this, "toggleRefresh", function () {
      var _this$props2 = _this.props,
        onRefreshChange = _this$props2.onRefreshChange,
        isPaused = _this$props2.isPaused;
      var _this$state3 = _this.state,
        units = _this$state3.units,
        value = _this$state3.value;
      if (!onRefreshChange || value === '') {
        return;
      }
      onRefreshChange({
        refreshInterval: toMilliseconds(units, value),
        intervalUnits: units,
        isPaused: !isPaused
      });
    });
    _defineProperty(_this, "renderScreenReaderText", function (refreshUnitsOptions) {
      var isPaused = _this.props.isPaused;
      var _this$state4 = _this.state,
        value = _this$state4.value,
        units = _this$state4.units;
      var options = refreshUnitsOptions.find(function (_ref2) {
        var value = _ref2.value;
        return value === units;
      });
      var optionText = options ? options.text : '';
      var fullDescription = isPaused ? ___EmotionJSX(EuiI18n, {
        token: "euiRefreshInterval.fullDescriptionOff",
        default: "Refresh is off, interval set to {optionValue} {optionText}.",
        values: {
          optionValue: value,
          optionText: optionText
        }
      }) : ___EmotionJSX(EuiI18n, {
        token: "euiRefreshInterval.fullDescriptionOn",
        default: "Refresh is on, interval set to {optionValue} {optionText}.",
        values: {
          optionValue: value,
          optionText: optionText
        }
      });
      return ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
        id: _this.refreshSelectionId
      }, fullDescription));
    });
    return _this;
  }
  _inherits(EuiRefreshInterval, _Component);
  return _createClass(EuiRefreshInterval, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var isPaused = this.props.isPaused;
      var _this$state5 = this.state,
        value = _this$state5.value,
        units = _this$state5.units,
        min = _this$state5.min;
      return ___EmotionJSX(EuiI18n, {
        tokens: ['euiRefreshInterval.toggleLabel', 'euiRefreshInterval.toggleAriaLabel', 'euiRefreshInterval.valueAriaLabel', 'euiRefreshInterval.unitsAriaLabel'],
        defaults: ['Refresh every', 'Toggle refresh', 'Refresh interval value', 'Refresh interval units']
      }, function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 4),
          toggleLabel = _ref4[0],
          toggleAriaLabel = _ref4[1],
          valueAriaLabel = _ref4[2],
          unitsAriaLabel = _ref4[3];
        return ___EmotionJSX(RenderI18nTimeOptions, null, function (_ref5) {
          var refreshUnitsOptions = _ref5.refreshUnitsOptions;
          return ___EmotionJSX(EuiQuickSelectPanel, null, ___EmotionJSX(EuiFlexGroup, {
            alignItems: "center",
            gutterSize: "s",
            responsive: false,
            wrap: true
          }, ___EmotionJSX(EuiFlexItem, {
            grow: false
          }, ___EmotionJSX(EuiSwitch, {
            "data-test-subj": "superDatePickerToggleRefreshButton",
            checked: !isPaused,
            onChange: _this2.toggleRefresh,
            compressed: true
            // The IDs attached to this visible label are unused - we override with our own aria-label
            ,
            label: ___EmotionJSX(EuiFormLabel, null, toggleLabel),
            "aria-label": toggleAriaLabel,
            "aria-labelledby": undefined,
            "aria-describedby": _this2.refreshSelectionId
          })), ___EmotionJSX(EuiFlexItem, {
            style: {
              minWidth: 60
            }
          }, ___EmotionJSX(EuiFieldNumber, {
            compressed: true,
            fullWidth: true,
            value: value,
            min: min,
            onChange: _this2.onValueChange,
            onKeyDown: _this2.handleKeyDown,
            isInvalid: !isPaused && (value === '' || value <= 0),
            disabled: isPaused,
            "aria-label": valueAriaLabel,
            "aria-describedby": _this2.refreshSelectionId,
            "data-test-subj": "superDatePickerRefreshIntervalInput"
          })), ___EmotionJSX(EuiFlexItem, {
            style: {
              minWidth: 100
            },
            grow: 2
          }, ___EmotionJSX(EuiSelect, {
            compressed: true,
            fullWidth: true,
            "aria-label": unitsAriaLabel,
            "aria-describedby": _this2.refreshSelectionId,
            value: units,
            disabled: isPaused,
            options: refreshUnitsOptions,
            onChange: _this2.onUnitsChange,
            onKeyDown: _this2.handleKeyDown,
            "data-test-subj": "superDatePickerRefreshIntervalUnitsSelect"
          }))), _this2.renderScreenReaderText(refreshUnitsOptions));
        });
      });
    }
  }]);
}(Component);
_defineProperty(EuiRefreshInterval, "defaultProps", {
  isPaused: true,
  refreshInterval: 1000,
  minInterval: 0
});