import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["adjustDateOnChange", "append", "calendarClassName", "className", "compressed", "controlOnly", "customInput", "dateFormat", "dayClassName", "disabled", "excludeDates", "filterDate", "fullWidth", "iconType", "injectTimes", "inline", "inputRef", "isInvalid", "isLoading", "locale", "maxDate", "maxTime", "minDate", "minTime", "onChange", "onClear", "openToDate", "placeholder", "popperClassName", "popoverPlacement", "prepend", "readOnly", "selected", "shadow", "shouldCloseOnSelect", "showIcon", "showTimeSelect", "showTimeSelectOnly", "timeFormat", "utcOffset"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useCallback } from 'react';
import classNames from 'classnames';
import { useCombinedRefs, useEuiMemoizedStyles } from '../../services';
import { EuiI18nConsumer } from '../context';
import { EuiFormControlLayout, useEuiValidatableControl } from '../form';
import { ReactDatePicker } from './react-datepicker';
import { euiReactDatePickerStyles } from './react_date_picker.styles';
import { euiDatePickerStyles } from './date_picker.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var euiDatePickerDefaultDateFormat = 'MM/DD/YYYY';
export var euiDatePickerDefaultTimeFormat = 'hh:mm A';

// EuiDatePicker only supports a subset of props from react-datepicker.
var unsupportedProps = [
// We don't want to show multiple months next to each other
'monthsShown',
// There is no need to show week numbers
'showWeekNumbers',
// Our css adapts to height, no need to fix it
'fixedHeight',
// We force the month / year selection UI. No need to configure it
'dropdownMode',
// Short month is unnecessary. Our UI has plenty of room for full months
'useShortMonthInDropdown',
// The today button is not needed. This should always be external to the calendar
'todayButton',
// We hide the time caption, so there is no need to overwrite its text
'timeCaption',
// We always want keyboard accessibility on
'disabledKeyboardNavigation',
// This is easy enough to do. It can conflict with isLoading state
'isClearable',
// There is no reason to launch the datepicker in its own modal. Can always build these ourselves
'withPortal',
// Causes Error: Cannot read property 'clone' of undefined
'showMonthYearDropdown',
// We overridde this with `popoverPlacement`
'popperPlacement',
// An internal EUI styling concern that consumers shouldn't need to access
'defaultInputProps'];
export var EuiDatePicker = function EuiDatePicker(_ref) {
  var _ref$adjustDateOnChan = _ref.adjustDateOnChange,
    adjustDateOnChange = _ref$adjustDateOnChan === void 0 ? true : _ref$adjustDateOnChan,
    append = _ref.append,
    calendarClassName = _ref.calendarClassName,
    className = _ref.className,
    compressed = _ref.compressed,
    controlOnly = _ref.controlOnly,
    customInput = _ref.customInput,
    _ref$dateFormat = _ref.dateFormat,
    dateFormat = _ref$dateFormat === void 0 ? euiDatePickerDefaultDateFormat : _ref$dateFormat,
    dayClassName = _ref.dayClassName,
    disabled = _ref.disabled,
    excludeDates = _ref.excludeDates,
    filterDate = _ref.filterDate,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    iconType = _ref.iconType,
    injectTimes = _ref.injectTimes,
    inline = _ref.inline,
    inputRef = _ref.inputRef,
    _isInvalid = _ref.isInvalid,
    isLoading = _ref.isLoading,
    locale = _ref.locale,
    maxDate = _ref.maxDate,
    maxTime = _ref.maxTime,
    minDate = _ref.minDate,
    minTime = _ref.minTime,
    onChange = _ref.onChange,
    onClear = _ref.onClear,
    openToDate = _ref.openToDate,
    placeholder = _ref.placeholder,
    popperClassName = _ref.popperClassName,
    _ref$popoverPlacement = _ref.popoverPlacement,
    popoverPlacement = _ref$popoverPlacement === void 0 ? 'downLeft' : _ref$popoverPlacement,
    prepend = _ref.prepend,
    readOnly = _ref.readOnly,
    selected = _ref.selected,
    _ref$shadow = _ref.shadow,
    shadow = _ref$shadow === void 0 ? true : _ref$shadow,
    _ref$shouldCloseOnSel = _ref.shouldCloseOnSelect,
    shouldCloseOnSelect = _ref$shouldCloseOnSel === void 0 ? true : _ref$shouldCloseOnSel,
    _ref$showIcon = _ref.showIcon,
    showIcon = _ref$showIcon === void 0 ? true : _ref$showIcon,
    _ref$showTimeSelect = _ref.showTimeSelect,
    showTimeSelect = _ref$showTimeSelect === void 0 ? false : _ref$showTimeSelect,
    showTimeSelectOnly = _ref.showTimeSelectOnly,
    _ref$timeFormat = _ref.timeFormat,
    timeFormat = _ref$timeFormat === void 0 ? euiDatePickerDefaultTimeFormat : _ref$timeFormat,
    utcOffset = _ref.utcOffset,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Check for whether the passed `selected` moment date is valid
  var isInvalid = _isInvalid || ((selected === null || selected === void 0 ? void 0 : selected.isValid()) === false ? true : undefined);
  var styles = useEuiMemoizedStyles(euiDatePickerStyles);
  var cssStyles = [styles.euiDatePicker].concat(_toConsumableArray(inline ? [styles.inline.inline, isInvalid && !(disabled || readOnly) && styles.inline.invalid, shadow ? styles.inline.shadow : styles.inline.noShadow, disabled && styles.inline.disabled, readOnly && styles.inline.readOnly] : []));
  var calendarStyles = useEuiMemoizedStyles(euiReactDatePickerStyles);
  var classes = classNames('euiDatePicker', className);

  // Passed to the default EuiFieldText input, not passed to custom inputs
  var defaultInputProps = !inline && !customInput ? {
    compressed: compressed,
    fullWidth: fullWidth
  } : undefined;

  // In case the consumer did not alter the default date format but wants
  // to add the time select, we append the default time format
  var fullDateFormat = dateFormat;
  if (showTimeSelect && dateFormat === euiDatePickerDefaultDateFormat) {
    fullDateFormat = "".concat(dateFormat, " ").concat(timeFormat);
  }

  // Set an internal ref on ReactDatePicker's `input` so we can set its :invalid state via useEuiValidatableControl
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    inputValidityRef = _useState2[0],
    _setInputValidityRef = _useState2[1];
  var setInputValidityRef = useCallback(function (ref) {
    _setInputValidityRef((ref === null || ref === void 0 ? void 0 : ref.input) || null);
  }, []);
  useEuiValidatableControl({
    isInvalid: isInvalid,
    controlEl: inputValidityRef
  });
  var inputRefs = useCombinedRefs([inputRef, setInputValidityRef]);
  var control = ___EmotionJSX(EuiI18nConsumer, null, function (_ref2) {
    var contextLocale = _ref2.locale;
    return ___EmotionJSX(ReactDatePicker, _extends({
      adjustDateOnChange: adjustDateOnChange,
      calendarClassName: classNames(calendarClassName, calendarStyles.euiReactDatePicker),
      className: classes,
      defaultInputProps: defaultInputProps,
      customInput: customInput,
      dateFormat: fullDateFormat,
      dayClassName: dayClassName,
      disabled: disabled,
      readOnly: readOnly,
      excludeDates: excludeDates,
      filterDate: filterDate,
      injectTimes: injectTimes,
      inline: inline,
      locale: locale || contextLocale,
      maxDate: maxDate,
      maxTime: maxTime,
      minDate: minDate,
      minTime: minTime,
      onChange: onChange,
      openToDate: openToDate,
      placeholderText: placeholder,
      popperClassName: popperClassName,
      ref: inputRefs,
      selected: selected,
      shouldCloseOnSelect: shouldCloseOnSelect,
      showMonthDropdown: true,
      showTimeSelect: showTimeSelectOnly ? true : showTimeSelect,
      showTimeSelectOnly: showTimeSelectOnly,
      showYearDropdown: true,
      timeFormat: timeFormat,
      utcOffset: utcOffset,
      yearDropdownItemNumber: 7,
      accessibleMode: !(disabled || readOnly),
      popperPlacement: popoverPlacement
    }, rest));
  });
  if (controlOnly) return control;
  var optionalIcon;
  if (inline || customInput || !showIcon) {
    optionalIcon = undefined;
  } else if (iconType) {
    optionalIcon = iconType;
  } else if (showTimeSelectOnly) {
    optionalIcon = 'clock';
  } else {
    optionalIcon = 'calendar';
  }
  return ___EmotionJSX("span", {
    css: cssStyles,
    className: classes
  }, ___EmotionJSX(EuiFormControlLayout, _extends({
    icon: optionalIcon,
    clear: selected && !disabled && onClear ? {
      onClick: onClear
    } : undefined,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: disabled,
    readOnly: readOnly
  }, inline ? {
    isDelimited: true,
    iconsPosition: 'static'
  } : {
    fullWidth: fullWidth,
    compressed: compressed,
    append: append,
    prepend: prepend,
    css: (append || prepend) && styles.inGroup
  }), control));
};