function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
import { euiShadowMedium } from '../../themes/amsterdam/global_styling/mixins';
import { euiFormControlDisabledStyles, euiFormControlReadOnlyStyles, euiFormControlDefaultShadow, euiFormControlInvalidStyles } from '../form/form.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1gj9wh1-euiDatePicker",
  styles: "display:block;label:euiDatePicker;"
} : {
  name: "1gj9wh1-euiDatePicker",
  styles: "display:block;label:euiDatePicker;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiDatePickerStyles = function euiDatePickerStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiDatePicker: _ref,
    inline: {
      inline: /*#__PURE__*/css(".euiFormControlLayout{", logicalCSS('height', 'auto'), " ", logicalCSS('width', 'fit-content'), " border:none;padding:0;}.euiFormControlLayout__childrenWrapper{flex-direction:column;}.euiFormControlLayoutIcons{justify-content:center;", logicalCSS('padding-bottom', euiTheme.size.s), ";};label:inline;"),
      // Skip css`` to avoid generating an Emotion className
      noShadow: "\n        .euiFormControlLayout {\n          background-color: transparent;\n        }\n      ",
      shadow: /*#__PURE__*/css(".euiFormControlLayout{background-color:", euiTheme.colors.emptyShade, ";", euiShadowMedium(euiThemeContext), ";};label:shadow;"),
      // Needs to come before shadow CSS so that it doesn't override their background-colors
      invalid: /*#__PURE__*/css(".euiFormControlLayout{", euiFormControlDefaultShadow(euiThemeContext, {
        withBorder: false
      }), " ", euiFormControlInvalidStyles(euiThemeContext), ";};label:invalid;"),
      // Should come after shadow CSS to override their background-colors
      disabled: /*#__PURE__*/css(".euiFormControlLayout{", euiFormControlDisabledStyles(euiThemeContext), ";};label:disabled;"),
      readOnly: /*#__PURE__*/css(".euiFormControlLayout{", euiFormControlReadOnlyStyles(euiThemeContext), ";};label:readOnly;")
    },
    inGroup: /*#__PURE__*/css(".euiFormControlLayout__childrenWrapper{.euiPopover,.react-datepicker__input-container{", logicalCSS('height', '100%'), ";}};label:inGroup;")
  };
};