import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "startDateControl", "endDateControl", "iconType", "inline", "shadow", "fullWidth", "compressed", "isCustom", "readOnly", "isLoading", "isInvalid", "disabled", "onFocus", "onBlur", "append", "prepend"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo, cloneElement } from 'react';
import classNames from 'classnames';
import { EuiFormControlLayoutDelimited } from '../form';
import { useEuiMemoizedStyles } from '../../services';
import { euiDatePickerRangeStyles as styles, euiDatePickerRangeInlineStyles } from './date_picker_range.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDatePickerRange = function EuiDatePickerRange(_ref) {
  var children = _ref.children,
    className = _ref.className,
    startDateControl = _ref.startDateControl,
    endDateControl = _ref.endDateControl,
    _ref$iconType = _ref.iconType,
    iconType = _ref$iconType === void 0 ? true : _ref$iconType,
    inline = _ref.inline,
    _ref$shadow = _ref.shadow,
    shadow = _ref$shadow === void 0 ? true : _ref$shadow,
    _fullWidth = _ref.fullWidth,
    _compressed = _ref.compressed,
    isCustom = _ref.isCustom,
    readOnly = _ref.readOnly,
    isLoading = _ref.isLoading,
    isInvalid = _ref.isInvalid,
    disabled = _ref.disabled,
    _onFocus = _ref.onFocus,
    _onBlur = _ref.onBlur,
    append = _ref.append,
    prepend = _ref.prepend,
    rest = _objectWithoutProperties(_ref, _excluded);
  // `fullWidth` and `compressed` should not affect inline datepickers (matches non-range behavior)
  var fullWidth = _fullWidth && !inline;
  var compressed = _compressed && !inline;
  var classes = classNames('euiDatePickerRange', className);
  var inlineStyles = useEuiMemoizedStyles(euiDatePickerRangeInlineStyles);
  var cssStyles = !inline ? styles.euiDatePickerRange : [inlineStyles.euiDatePickerRangeInline,
  // Determine the inline container query to use based on the width of the react-datepicker
  startDateControl.props.showTimeSelect || endDateControl.props.showTimeSelect ? inlineStyles.responsiveWithTimeSelect : inlineStyles.responsive, shadow && inlineStyles.shadow];
  var startControl = startDateControl;
  var endControl = endDateControl;
  if (!isCustom) {
    startControl = /*#__PURE__*/cloneElement(startDateControl, {
      controlOnly: true,
      showIcon: false,
      inline: inline,
      compressed: compressed,
      fullWidth: fullWidth,
      readOnly: readOnly,
      disabled: disabled || startDateControl.props.disabled,
      isInvalid: isInvalid || startDateControl.props.isInvalid,
      className: classNames('euiDatePickerRange__start', startDateControl.props.className),
      onBlur: function onBlur(event) {
        var _startDateControl$pro, _startDateControl$pro2;
        (_startDateControl$pro = startDateControl.props) === null || _startDateControl$pro === void 0 || (_startDateControl$pro2 = _startDateControl$pro.onBlur) === null || _startDateControl$pro2 === void 0 || _startDateControl$pro2.call(_startDateControl$pro, event);
        _onBlur === null || _onBlur === void 0 || _onBlur(event);
      },
      onFocus: function onFocus(event) {
        var _startDateControl$pro3, _startDateControl$pro4;
        (_startDateControl$pro3 = startDateControl.props) === null || _startDateControl$pro3 === void 0 || (_startDateControl$pro4 = _startDateControl$pro3.onFocus) === null || _startDateControl$pro4 === void 0 || _startDateControl$pro4.call(_startDateControl$pro3, event);
        _onFocus === null || _onFocus === void 0 || _onFocus(event);
      }
    });
    endControl = /*#__PURE__*/cloneElement(endDateControl, {
      controlOnly: true,
      showIcon: false,
      inline: inline,
      compressed: compressed,
      fullWidth: fullWidth,
      readOnly: readOnly,
      disabled: disabled || endDateControl.props.disabled,
      isInvalid: isInvalid || endDateControl.props.isInvalid,
      popoverPlacement: 'downRight',
      className: classNames('euiDatePickerRange__end', endDateControl.props.className),
      onBlur: function onBlur(event) {
        var _endDateControl$props, _endDateControl$props2;
        (_endDateControl$props = endDateControl.props) === null || _endDateControl$props === void 0 || (_endDateControl$props2 = _endDateControl$props.onBlur) === null || _endDateControl$props2 === void 0 || _endDateControl$props2.call(_endDateControl$props, event);
        _onBlur === null || _onBlur === void 0 || _onBlur(event);
      },
      onFocus: function onFocus(event) {
        var _endDateControl$props3, _endDateControl$props4;
        (_endDateControl$props3 = endDateControl.props) === null || _endDateControl$props3 === void 0 || (_endDateControl$props4 = _endDateControl$props3.onFocus) === null || _endDateControl$props4 === void 0 || _endDateControl$props4.call(_endDateControl$props3, event);
        _onFocus === null || _onFocus === void 0 || _onFocus(event);
      }
    });
  }
  var icon = useMemo(function () {
    if (inline) return undefined;
    if (iconType === false) return undefined;
    if (iconType === true) return 'calendar';
    return iconType;
  }, [iconType, inline]);
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles
  }, rest), ___EmotionJSX(EuiFormControlLayoutDelimited, {
    icon: icon,
    startControl: startControl,
    endControl: endControl,
    fullWidth: fullWidth,
    compressed: compressed,
    readOnly: readOnly,
    isDisabled: disabled,
    isInvalid: isInvalid,
    isLoading: isLoading,
    append: inline ? undefined : append,
    prepend: inline ? undefined : prepend,
    css: inline && !disabled && (shadow ? inlineStyles.formLayout.shadow : inlineStyles.formLayout.noShadow)
  }));
};