import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useEffect, useCallback } from 'react';
import moment from 'moment';
import dateMath from '@elastic/datemath';
import { useUpdateEffect, useEuiMemoizedStyles } from '../../../../services';
import { useEuiI18n } from '../../../i18n';
import { EuiFormRow, EuiFieldText, EuiFormLabel } from '../../../form';
import { EuiFlexGroup } from '../../../flex';
import { EuiButtonIcon } from '../../../button';
import { EuiCode } from '../../../code';
import { EuiDatePicker } from '../../date_picker';
import { euiAbsoluteTabDateFormStyles } from './absolute_tab.styles';

// Allow users to paste in and have the datepicker parse multiple common date formats,
// in addition to the configured displayed `dateFormat` prop
import { jsx as ___EmotionJSX } from "@emotion/react";
var ALLOWED_USER_DATE_FORMATS = [moment.ISO_8601, moment.RFC_2822, 'X' // Unix timestamp in seconds
];
export var EuiAbsoluteTab = function EuiAbsoluteTab(_ref) {
  var value = _ref.value,
    onChange = _ref.onChange,
    dateFormat = _ref.dateFormat,
    timeFormat = _ref.timeFormat,
    locale = _ref.locale,
    roundUp = _ref.roundUp,
    utcOffset = _ref.utcOffset,
    minDate = _ref.minDate,
    maxDate = _ref.maxDate,
    labelPrefix = _ref.labelPrefix;
  var styles = useEuiMemoizedStyles(euiAbsoluteTabDateFormStyles);
  var _useState = useState(function () {
      var parsedValue = dateMath.parse(value, {
        roundUp: roundUp
      });
      return parsedValue && parsedValue.isValid() ? parsedValue : moment();
    }),
    _useState2 = _slicedToArray(_useState, 2),
    valueAsMoment = _useState2[0],
    setValueAsMoment = _useState2[1];
  var handleChange = useCallback(function (date) {
    if (date === null) return;
    var valueAsMoment = moment(date);
    setValueAsMoment(valueAsMoment);
    setTextInputValue(valueAsMoment.format(dateFormat));
    setHasUnparsedText(false);
    setIsTextInvalid(false);
  }, [dateFormat]);
  var submitButtonLabel = useEuiI18n('euiAbsoluteTab.dateFormatButtonLabel', 'Parse date');
  var dateFormatError = useEuiI18n('euiAbsoluteTab.dateFormatError', 'Allowed formats: {dateFormat}, ISO 8601, RFC 2822, or Unix timestamp.', {
    dateFormat: ___EmotionJSX(EuiCode, null, dateFormat)
  });
  var _useState3 = useState(function () {
      return valueAsMoment.locale(locale || 'en').format(dateFormat);
    }),
    _useState4 = _slicedToArray(_useState3, 2),
    textInputValue = _useState4[0],
    setTextInputValue = _useState4[1];
  var _useState5 = useState(false),
    _useState6 = _slicedToArray(_useState5, 2),
    hasUnparsedText = _useState6[0],
    setHasUnparsedText = _useState6[1];
  var _useState7 = useState(false),
    _useState8 = _slicedToArray(_useState7, 2),
    isReadyToParse = _useState8[0],
    setIsReadyToParse = _useState8[1];
  var _useState9 = useState(false),
    _useState10 = _slicedToArray(_useState9, 2),
    isTextInvalid = _useState10[0],
    setIsTextInvalid = _useState10[1];
  var handleTextChange = useCallback(function (event) {
    if (isReadyToParse) return; // Text paste event, don't continue

    setTextInputValue(event.target.value);
    setHasUnparsedText(true);
    setIsTextInvalid(false);
  }, [isReadyToParse]);
  useEffect(function () {
    if (isReadyToParse) {
      if (!textInputValue) {
        setIsTextInvalid(true);
        setValueAsMoment(null);
        return;
      }

      // Attempt to parse with passed `dateFormat` and `locale`
      var _valueAsMoment = moment(textInputValue, dateFormat, typeof locale === 'string' ? locale : 'en',
      // Narrow the union type to string
      true);
      var dateIsValid = _valueAsMoment.isValid();

      // If not valid, try a few other standardized formats
      if (!dateIsValid) {
        _valueAsMoment = moment(textInputValue, ALLOWED_USER_DATE_FORMATS, true);
        dateIsValid = _valueAsMoment.isValid();
      }
      if (dateIsValid) {
        setTextInputValue(_valueAsMoment.format(dateFormat));
        setValueAsMoment(_valueAsMoment);
        setHasUnparsedText(false);
        setIsTextInvalid(false);
      } else {
        setIsTextInvalid(true);
        setValueAsMoment(null);
      }
      setIsReadyToParse(false);
    }
  }, [isReadyToParse, textInputValue, dateFormat, locale]);
  useUpdateEffect(function () {
    if (valueAsMoment) {
      onChange(valueAsMoment.toISOString());
    }
  }, [valueAsMoment]);
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiDatePicker, {
    inline: true,
    showTimeSelect: true,
    shadow: false,
    selected: valueAsMoment,
    onChange: handleChange,
    dateFormat: dateFormat,
    timeFormat: timeFormat,
    locale: locale,
    utcOffset: utcOffset,
    minDate: minDate,
    maxDate: maxDate
  }), ___EmotionJSX(EuiFlexGroup, {
    component: "form",
    onSubmit: function onSubmit(e) {
      e.preventDefault(); // Prevents a page refresh/reload
      setIsReadyToParse(true);
    },
    css: styles.euiAbsoluteTabDateForm,
    gutterSize: "s",
    responsive: false
  }, ___EmotionJSX(EuiFormRow, {
    css: styles.euiAbsoluteTabDateForm__row,
    isInvalid: isTextInvalid,
    error: isTextInvalid ? dateFormatError : undefined,
    helpText: hasUnparsedText && !isTextInvalid ? dateFormatError : undefined
  }, ___EmotionJSX(EuiFieldText, {
    compressed: true,
    isInvalid: isTextInvalid,
    value: textInputValue,
    onChange: handleTextChange,
    onPaste: function onPaste(event) {
      setTextInputValue(event.clipboardData.getData('text'));
      setIsReadyToParse(true);
    },
    "data-test-subj": "superDatePickerAbsoluteDateInput",
    prepend: ___EmotionJSX(EuiFormLabel, null, labelPrefix)
  })), hasUnparsedText && ___EmotionJSX(EuiButtonIcon, {
    type: "submit",
    css: styles.euiAbsoluteTabDateForm__submit,
    size: "s",
    display: "base",
    iconType: "check",
    "aria-label": submitButtonLabel,
    title: submitButtonLabel,
    "data-test-subj": "parseAbsoluteDateFormat"
  })));
};