import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["component", "title", "titleId", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { useEuiMemoizedStyles } from '../../../../services';
import { EuiTitle } from '../../../title';
import { euiQuickSelectPanelStyles } from './quick_select_panel.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiQuickSelectPanel = function EuiQuickSelectPanel(_ref) {
  var _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    title = _ref.title,
    titleId = _ref.titleId,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isFieldset = Component === 'fieldset';
  var TitleComponent = isFieldset ? 'legend' : 'span';
  var styles = useEuiMemoizedStyles(euiQuickSelectPanelStyles);
  return ___EmotionJSX(Component, _extends({
    css: styles.euiQuickSelectPanel
  }, rest), title ? ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiTitle, {
    size: "xxxs"
  }, ___EmotionJSX(TitleComponent, {
    id: titleId,
    css: styles.euiQuickSelectPanel__title
  }, title)), ___EmotionJSX("div", {
    css: styles.euiQuickSelectPanel__section
  }, children)) : children);
};