import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />

import React, { useState } from 'react';
import { EuiSuperDatePicker } from './super_date_picker';
import { jsx as ___EmotionJSX } from "@emotion/react";
var SuperDatePicker = function SuperDatePicker() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isLoading = _useState2[0],
    setIsLoading = _useState2[1];
  var _useState3 = useState(true),
    _useState4 = _slicedToArray(_useState3, 1),
    showUpdateButton = _useState4[0];
  var _useState5 = useState('now-30m'),
    _useState6 = _slicedToArray(_useState5, 2),
    start = _useState6[0],
    setStart = _useState6[1];
  var _useState7 = useState('now'),
    _useState8 = _slicedToArray(_useState7, 2),
    end = _useState8[0],
    setEnd = _useState8[1];
  var _useState9 = useState(true),
    _useState10 = _slicedToArray(_useState9, 1),
    showFill = _useState10[0];
  var onTimeChange = function onTimeChange(_ref) {
    var start = _ref.start,
      end = _ref.end;
    setStart(start);
    setEnd(end);
    setIsLoading(true);
    startLoading();
  };
  var startLoading = function startLoading() {
    setTimeout(stopLoading, 1000);
  };
  var stopLoading = function stopLoading() {
    setIsLoading(false);
  };
  var datepickerProps = {
    isLoading: isLoading,
    start: start,
    end: end,
    onTimeChange: onTimeChange,
    showUpdateButton: showUpdateButton
  };
  return ___EmotionJSX(EuiSuperDatePicker, _extends({}, datepickerProps, {
    updateButtonProps: {
      fill: showFill
    }
  }));
};
beforeEach(function () {
  cy.mount(___EmotionJSX(SuperDatePicker, null));
  cy.get('div.euiSuperDatePicker').should('exist');
});
describe('EuiSuperDatePicker', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when quick select menu is open', function () {
      cy.get('[data-test-subj="superDatePickerToggleQuickMenuButton"]').click();
      cy.get('div.euiPanel').contains('Quick select').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when start / end date menus are open', function () {
      cy.get('button.euiSuperDatePicker__prettyFormat').click();
      cy.get('div.euiDatePopoverContent').should('exist');
      cy.checkAxe();
      cy.get('button.euiDatePopoverButton--start').click();
      cy.get('button.euiDatePopoverButton--end').click();
      cy.get('div.euiDatePopoverContent').should('exist');
      cy.checkAxe();
      cy.get('button.euiDatePopoverButton--end').click();
      cy.get('div.euiDatePopoverContent').should('not.exist');
      cy.checkAxe();
    });
  });
});