import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["isDisabled"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import moment from 'moment'; // eslint-disable-line import/named
import dateMath from '@elastic/datemath';
import { useEuiMemoizedStyles } from '../../../services';
import { isObject } from '../../../services/predicate';
import { EuiI18nConsumer } from '../../context';
import { EuiDatePickerRange } from '../date_picker_range';
import { EuiFormControlLayout } from '../../form';
import { RenderI18nTimeOptions } from './time_options';
import { PrettyDuration, showPrettyDuration } from './pretty_duration';
import { AsyncInterval } from './async_interval';
import { EuiSuperUpdateButton } from './super_update_button';
import { EuiQuickSelectPopover } from './quick_select_popover/quick_select_popover';
import { EuiDatePopoverButton } from './date_popover/date_popover_button';
import { EuiAutoRefresh, EuiAutoRefreshButton } from '../auto_refresh/auto_refresh';
import { euiSuperDatePickerStyles } from './super_date_picker.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
function isRangeInvalid(start, end, minDate, maxDate) {
  if (start === 'now' && end === 'now') {
    return true;
  }
  var startMoment = dateMath.parse(start);
  var endMoment = dateMath.parse(end, {
    roundUp: true
  });
  var isInvalid = !startMoment || !endMoment || !startMoment.isValid() || !endMoment.isValid() || !moment(startMoment).isValid() || !moment(endMoment).isValid() || startMoment.isAfter(endMoment) || endMoment.isBefore(startMoment) || minDate != null && startMoment.isBefore(minDate) || maxDate != null && endMoment.isAfter(maxDate);
  return isInvalid;
}
export var EuiSuperDatePickerInternal = /*#__PURE__*/function (_Component) {
  function EuiSuperDatePickerInternal() {
    var _this;
    _classCallCheck(this, EuiSuperDatePickerInternal);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSuperDatePickerInternal, [].concat(args));
    _defineProperty(_this, "asyncInterval", void 0);
    _defineProperty(_this, "state", {
      prevProps: {
        start: _this.props.start,
        end: _this.props.end
      },
      start: _this.props.start,
      end: _this.props.end,
      isInvalid: isRangeInvalid(_this.props.start, _this.props.end, _this.props.minDate, _this.props.maxDate),
      hasChanged: false,
      showPrettyDuration: showPrettyDuration(_this.props.start, _this.props.end, _this.props.commonlyUsedRanges),
      isStartDatePopoverOpen: false,
      isEndDatePopoverOpen: false
    });
    _defineProperty(_this, "setTime", function (_ref) {
      var end = _ref.end,
        start = _ref.start;
      var isInvalid = isRangeInvalid(start, end, _this.props.minDate, _this.props.maxDate);
      _this.setState({
        start: start,
        end: end,
        isInvalid: isInvalid,
        hasChanged: !(_this.state.prevProps.start === start && _this.state.prevProps.end === end)
      });
      if (!_this.props.showUpdateButton) {
        _this.props.onTimeChange({
          start: start,
          end: end,
          isQuickSelection: false,
          isInvalid: isInvalid
        });
      }
    });
    _defineProperty(_this, "componentDidMount", function () {
      if (!_this.props.isPaused) {
        _this.startInterval(_this.props.refreshInterval);
      }
    });
    _defineProperty(_this, "componentDidUpdate", function () {
      _this.stopInterval();
      if (!_this.props.isPaused) {
        _this.startInterval(_this.props.refreshInterval);
      }
    });
    _defineProperty(_this, "componentWillUnmount", function () {
      _this.stopInterval();
    });
    _defineProperty(_this, "setStart", function (start) {
      _this.setTime({
        start: start,
        end: _this.state.end
      });
    });
    _defineProperty(_this, "setEnd", function (end) {
      _this.setTime({
        start: _this.state.start,
        end: end
      });
    });
    _defineProperty(_this, "applyTime", function () {
      _this.props.onTimeChange({
        start: _this.state.start,
        end: _this.state.end,
        isQuickSelection: false,
        isInvalid: false
      });
    });
    _defineProperty(_this, "applyQuickTime", function (_ref2) {
      var start = _ref2.start,
        end = _ref2.end;
      _this.setState({
        showPrettyDuration: showPrettyDuration(start, end, _this.props.commonlyUsedRanges)
      });
      _this.props.onTimeChange({
        start: start,
        end: end,
        isQuickSelection: true,
        isInvalid: false
      });
    });
    _defineProperty(_this, "hidePrettyDuration", function () {
      _this.setState({
        showPrettyDuration: false,
        isStartDatePopoverOpen: true
      });
    });
    _defineProperty(_this, "onStartDatePopoverToggle", function () {
      _this.setState(function (prevState) {
        return {
          isStartDatePopoverOpen: !prevState.isStartDatePopoverOpen
        };
      });
    });
    _defineProperty(_this, "onStartDatePopoverClose", function () {
      _this.setState({
        isStartDatePopoverOpen: false
      });
    });
    _defineProperty(_this, "onEndDatePopoverToggle", function () {
      _this.setState(function (prevState) {
        return {
          isEndDatePopoverOpen: !prevState.isEndDatePopoverOpen
        };
      });
    });
    _defineProperty(_this, "onEndDatePopoverClose", function () {
      _this.setState({
        isEndDatePopoverOpen: false
      });
    });
    _defineProperty(_this, "onRefreshChange", function (_ref3) {
      var refreshInterval = _ref3.refreshInterval,
        intervalUnits = _ref3.intervalUnits,
        isPaused = _ref3.isPaused;
      _this.stopInterval();
      if (!isPaused) {
        _this.startInterval(refreshInterval);
      }
      if (_this.props.onRefreshChange) {
        _this.props.onRefreshChange({
          refreshInterval: refreshInterval,
          isPaused: isPaused,
          intervalUnits: intervalUnits
        });
      }
    });
    _defineProperty(_this, "stopInterval", function () {
      if (_this.asyncInterval) {
        _this.asyncInterval.stop();
      }
    });
    _defineProperty(_this, "startInterval", function (refreshInterval) {
      var onRefresh = _this.props.onRefresh;
      if (onRefresh) {
        var handler = function handler() {
          var _this$props = _this.props,
            start = _this$props.start,
            end = _this$props.end;
          onRefresh({
            start: start,
            end: end,
            refreshInterval: refreshInterval
          });
        };
        _this.asyncInterval = new AsyncInterval(handler, refreshInterval);
      }
    });
    _defineProperty(_this, "renderQuickSelect", function () {
      var _this$props2 = _this.props,
        start = _this$props2.start,
        end = _this$props2.end,
        customQuickSelectPanels = _this$props2.customQuickSelectPanels,
        customQuickSelectRender = _this$props2.customQuickSelectRender,
        commonlyUsedRanges = _this$props2.commonlyUsedRanges,
        timeOptions = _this$props2.timeOptions,
        dateFormat = _this$props2.dateFormat,
        onRefreshChange = _this$props2.onRefreshChange,
        recentlyUsedRanges = _this$props2.recentlyUsedRanges,
        refreshInterval = _this$props2.refreshInterval,
        refreshMinInterval = _this$props2.refreshMinInterval,
        refreshIntervalUnits = _this$props2.refreshIntervalUnits,
        isPaused = _this$props2.isPaused,
        isDisabled = _this$props2.isDisabled;
      return ___EmotionJSX(EuiQuickSelectPopover, {
        applyRefreshInterval: onRefreshChange ? _this.onRefreshChange : undefined,
        applyTime: _this.applyQuickTime,
        commonlyUsedRanges: commonlyUsedRanges,
        customQuickSelectPanels: customQuickSelectPanels,
        customQuickSelectRender: customQuickSelectRender,
        dateFormat: dateFormat,
        end: end,
        isDisabled: !!isDisabled,
        isPaused: isPaused,
        recentlyUsedRanges: recentlyUsedRanges,
        refreshInterval: refreshInterval,
        refreshMinInterval: refreshMinInterval,
        intervalUnits: refreshIntervalUnits,
        start: start,
        timeOptions: timeOptions
      });
    });
    _defineProperty(_this, "renderDatePickerRange", function () {
      var _this$state = _this.state,
        end = _this$state.end,
        hasChanged = _this$state.hasChanged,
        isEndDatePopoverOpen = _this$state.isEndDatePopoverOpen,
        isInvalid = _this$state.isInvalid,
        isStartDatePopoverOpen = _this$state.isStartDatePopoverOpen,
        showPrettyDuration = _this$state.showPrettyDuration,
        start = _this$state.start;
      var _this$props3 = _this.props,
        isQuickSelectOnly = _this$props3.isQuickSelectOnly,
        showUpdateButton = _this$props3.showUpdateButton,
        commonlyUsedRanges = _this$props3.commonlyUsedRanges,
        canRoundRelativeUnits = _this$props3.canRoundRelativeUnits,
        timeOptions = _this$props3.timeOptions,
        dateFormat = _this$props3.dateFormat,
        refreshInterval = _this$props3.refreshInterval,
        refreshMinInterval = _this$props3.refreshMinInterval,
        refreshIntervalUnits = _this$props3.refreshIntervalUnits,
        isPaused = _this$props3.isPaused,
        isDisabled = _this$props3.isDisabled,
        isLoading = _this$props3.isLoading,
        locale = _this$props3.locale,
        timeFormat = _this$props3.timeFormat,
        utcOffset = _this$props3.utcOffset,
        minDate = _this$props3.minDate,
        maxDate = _this$props3.maxDate,
        compressed = _this$props3.compressed,
        onFocus = _this$props3.onFocus,
        styles = _this$props3.memoizedStyles;
      var autoRefreshAppend = !isPaused ? ___EmotionJSX(EuiAutoRefreshButton, {
        refreshInterval: refreshInterval,
        minInterval: refreshMinInterval,
        intervalUnits: refreshIntervalUnits,
        isDisabled: !!isDisabled,
        isPaused: isPaused,
        onRefreshChange: _this.onRefreshChange,
        shortHand: true
      }) : undefined;
      var formControlLayoutProps = {
        compressed: compressed,
        isInvalid: isInvalid,
        isLoading: isLoading && !showUpdateButton,
        isDisabled: !!isDisabled,
        prepend: _this.renderQuickSelect(),
        append: autoRefreshAppend,
        fullWidth: true,
        css: [styles.states.euiSuperDatePicker__formControlLayout, isDisabled ? styles.states.disabled : isInvalid ? styles.states.invalid : hasChanged ? styles.states.needsUpdating : styles.states.default]
      };
      if (isQuickSelectOnly) {
        return ___EmotionJSX(EuiFormControlLayout, _extends({
          iconsPosition: "static"
        }, formControlLayoutProps));
      }
      var isDisabledDisplay = isObject(isDisabled) && (isDisabled === null || isDisabled === void 0 ? void 0 : isDisabled.display);
      if (isDisabledDisplay || showPrettyDuration && !isStartDatePopoverOpen && !isEndDatePopoverOpen) {
        return ___EmotionJSX(EuiFormControlLayout, formControlLayoutProps, ___EmotionJSX("button", {
          type: "button",
          css: styles.euiSuperDatePicker__prettyFormat,
          className: classNames('euiSuperDatePicker__prettyFormat', {
            'euiSuperDatePicker__prettyFormat--disabled': isDisabled
          }),
          "data-test-subj": "superDatePickerShowDatesButton",
          disabled: !!isDisabled,
          onClick: _this.hidePrettyDuration,
          onFocus: onFocus
        }, isDisabledDisplay ? isDisabled.display : ___EmotionJSX(PrettyDuration, {
          timeFrom: start,
          timeTo: end,
          quickRanges: commonlyUsedRanges,
          dateFormat: dateFormat
        })));
      }
      var rangeCssStyles = [styles.euiSuperDatePicker__range, formControlLayoutProps.css];

      // EuiFormControlLayout wants `isDisabled`, EuiDatePickerRange wants `disabled` :T
      var _ = formControlLayoutProps.isDisabled,
        _rangeProps = _objectWithoutProperties(formControlLayoutProps, _excluded);
      var rangeProps = _objectSpread(_objectSpread({}, _rangeProps), {}, {
        disabled: formControlLayoutProps.isDisabled
      });
      return ___EmotionJSX(EuiI18nConsumer, null, function (_ref4) {
        var contextLocale = _ref4.locale;
        return ___EmotionJSX(EuiDatePickerRange, _extends({}, rangeProps, {
          css: rangeCssStyles,
          isCustom: true,
          iconType: false,
          startDateControl: ___EmotionJSX(EuiDatePopoverButton, {
            css: styles.euiSuperDatePicker__rangeInput,
            className: "euiSuperDatePicker__startPopoverButton",
            compressed: compressed,
            position: "start",
            needsUpdating: hasChanged,
            isInvalid: isInvalid,
            isDisabled: !!isDisabled,
            onChange: _this.setStart,
            value: start,
            dateFormat: dateFormat,
            utcOffset: utcOffset,
            timeFormat: timeFormat,
            locale: locale || contextLocale,
            minDate: minDate,
            maxDate: maxDate,
            canRoundRelativeUnits: canRoundRelativeUnits,
            isOpen: _this.state.isStartDatePopoverOpen,
            onPopoverToggle: _this.onStartDatePopoverToggle,
            onPopoverClose: _this.onStartDatePopoverClose,
            timeOptions: timeOptions,
            buttonProps: {
              onFocus: onFocus
            }
          }),
          endDateControl: ___EmotionJSX(EuiDatePopoverButton, {
            css: styles.euiSuperDatePicker__rangeInput,
            position: "end",
            compressed: compressed,
            needsUpdating: hasChanged,
            isInvalid: isInvalid,
            isDisabled: !!isDisabled,
            onChange: _this.setEnd,
            value: end,
            dateFormat: dateFormat,
            utcOffset: utcOffset,
            timeFormat: timeFormat,
            locale: locale || contextLocale,
            minDate: minDate,
            maxDate: maxDate,
            canRoundRelativeUnits: canRoundRelativeUnits,
            roundUp: true,
            isOpen: _this.state.isEndDatePopoverOpen,
            onPopoverToggle: _this.onEndDatePopoverToggle,
            onPopoverClose: _this.onEndDatePopoverClose,
            timeOptions: timeOptions,
            buttonProps: {
              onFocus: onFocus
            }
          })
        }));
      });
    });
    _defineProperty(_this, "handleClickUpdateButton", function () {
      if (!_this.state.hasChanged && _this.props.onRefresh) {
        var _this$props4 = _this.props,
          start = _this$props4.start,
          end = _this$props4.end,
          refreshInterval = _this$props4.refreshInterval;
        _this.props.onRefresh({
          start: start,
          end: end,
          refreshInterval: refreshInterval
        });
      } else {
        _this.applyTime();
      }
    });
    _defineProperty(_this, "renderUpdateButton", function () {
      var _this$props5 = _this.props,
        isLoading = _this$props5.isLoading,
        isDisabled = _this$props5.isDisabled,
        updateButtonProps = _this$props5.updateButtonProps,
        showUpdateButton = _this$props5.showUpdateButton,
        compressed = _this$props5.compressed;
      if (!showUpdateButton) return null;
      return ___EmotionJSX(EuiSuperUpdateButton, _extends({
        needsUpdate: _this.state.hasChanged,
        showTooltip: !_this.state.isStartDatePopoverOpen && !_this.state.isEndDatePopoverOpen,
        isLoading: isLoading,
        isDisabled: !!isDisabled || _this.state.isInvalid,
        onClick: _this.handleClickUpdateButton,
        "data-test-subj": "superDatePickerApplyTimeButton",
        size: compressed ? 's' : 'm',
        iconOnly: showUpdateButton === 'iconOnly'
      }, updateButtonProps));
    });
    return _this;
  }
  _inherits(EuiSuperDatePickerInternal, _Component);
  return _createClass(EuiSuperDatePickerInternal, [{
    key: "render",
    value: function render() {
      var _this$props6 = this.props,
        isAutoRefreshOnly = _this$props6.isAutoRefreshOnly,
        isDisabled = _this$props6.isDisabled,
        isPaused = _this$props6.isPaused,
        onRefreshChange = _this$props6.onRefreshChange,
        refreshInterval = _this$props6.refreshInterval,
        refreshMinInterval = _this$props6.refreshMinInterval,
        refreshIntervalUnits = _this$props6.refreshIntervalUnits,
        showUpdateButton = _this$props6.showUpdateButton,
        dataTestSubj = _this$props6['data-test-subj'],
        _width = _this$props6.width,
        isQuickSelectOnly = _this$props6.isQuickSelectOnly,
        compressed = _this$props6.compressed,
        className = _this$props6.className,
        styles = _this$props6.memoizedStyles;
      var _this$state2 = this.state,
        hasChanged = _this$state2.hasChanged,
        isInvalid = _this$state2.isInvalid;
      var classes = classNames('euiSuperDatePicker', className, {
        'euiSuperDatePicker--needsUpdating': hasChanged && !isDisabled && !isInvalid
      });

      // Force reduction in width if showing quick select only
      var width = isQuickSelectOnly ? 'auto' : _width !== null && _width !== void 0 ? _width : 'restricted';
      var cssStyles = [styles.euiSuperDatePicker, styles.widths[width], !showUpdateButton && styles.noUpdateButton[width], isAutoRefreshOnly && styles.isAutoRefreshOnly[width], isQuickSelectOnly && styles.isQuickSelectOnly];
      return ___EmotionJSX("div", {
        css: cssStyles,
        className: classes,
        "data-test-subj": dataTestSubj
      }, isAutoRefreshOnly && onRefreshChange ? ___EmotionJSX(EuiAutoRefresh, {
        isPaused: isPaused,
        refreshInterval: refreshInterval,
        minInterval: refreshMinInterval,
        intervalUnits: refreshIntervalUnits,
        onRefreshChange: this.onRefreshChange,
        fullWidth: width === 'full',
        compressed: compressed,
        isDisabled: !!isDisabled,
        className: className
      }) : ___EmotionJSX(React.Fragment, null, this.renderDatePickerRange(), this.renderUpdateButton()));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (nextProps.start !== prevState.prevProps.start || nextProps.end !== prevState.prevProps.end) {
        return {
          prevProps: {
            start: nextProps.start,
            end: nextProps.end
          },
          start: nextProps.start,
          end: nextProps.end,
          isInvalid: isRangeInvalid(nextProps.start, nextProps.end, nextProps.minDate, nextProps.maxDate),
          hasChanged: false,
          showPrettyDuration: showPrettyDuration(nextProps.start, nextProps.end, nextProps.commonlyUsedRanges)
        };
      }
      return null;
    }
  }]);
}(Component);

// Because EuiSuperDatePicker is a class component and not a functional component,
// we have to use a render prop here in order for us to pass i18n'd strings/objects/etc
// to all underlying usages of our timeOptions constants. If someday we convert
// EuiSuperDatePicker to an FC, we can likely get rid of this wrapper.
_defineProperty(EuiSuperDatePickerInternal, "defaultProps", {
  dateFormat: 'MMM D, YYYY @ HH:mm:ss.SSS',
  end: 'now',
  isAutoRefreshOnly: false,
  isDisabled: false,
  isPaused: true,
  recentlyUsedRanges: [],
  refreshInterval: 1000,
  showUpdateButton: true,
  canRoundRelativeUnits: true,
  start: 'now-15m',
  timeFormat: 'HH:mm',
  width: 'restricted'
});
export var EuiSuperDatePicker = function EuiSuperDatePicker(props) {
  var styles = useEuiMemoizedStyles(euiSuperDatePickerStyles);
  return ___EmotionJSX(RenderI18nTimeOptions, null, function (timeOptions) {
    return ___EmotionJSX(EuiSuperDatePickerInternal, _extends({}, props, {
      timeOptions: timeOptions,
      commonlyUsedRanges: props.commonlyUsedRanges || timeOptions.commonDurationRanges,
      memoizedStyles: styles
    }));
  });
};