import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "className", "needsUpdate", "isLoading", "isDisabled", "onClick", "toolTipProps", "showTooltip", "iconOnly", "responsive", "textProps", "fill"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { EuiButton } from '../../button';
import { EuiI18n } from '../../i18n';
import { EuiToolTip } from '../../tool_tip';
import { EuiHideFor, EuiShowFor } from '../../responsive';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSuperUpdateButton = /*#__PURE__*/function (_Component) {
  function EuiSuperUpdateButton() {
    var _this;
    _classCallCheck(this, EuiSuperUpdateButton);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSuperUpdateButton, [].concat(args));
    _defineProperty(_this, "_isMounted", false);
    _defineProperty(_this, "tooltipTimeout", void 0);
    _defineProperty(_this, "tooltip", null);
    _defineProperty(_this, "setTootipRef", function (node) {
      _this.tooltip = node;
    });
    _defineProperty(_this, "showTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }
      _this.tooltip.showToolTip();
    });
    _defineProperty(_this, "hideTooltip", function () {
      if (!_this._isMounted || !_this.tooltip) {
        return;
      }
      _this.tooltip.hideToolTip();
    });
    return _this;
  }
  _inherits(EuiSuperUpdateButton, _Component);
  return _createClass(EuiSuperUpdateButton, [{
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      var _this2 = this;
      if (this.props.showTooltip && this.props.needsUpdate && !this.props.isDisabled && !this.props.isLoading) {
        this.showTooltip();
        this.tooltipTimeout = setTimeout(function () {
          _this2.hideTooltip();
        }, 2000);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        children = _this$props.children,
        className = _this$props.className,
        needsUpdate = _this$props.needsUpdate,
        isLoading = _this$props.isLoading,
        isDisabled = _this$props.isDisabled,
        onClick = _this$props.onClick,
        toolTipProps = _this$props.toolTipProps,
        showTooltip = _this$props.showTooltip,
        iconOnly = _this$props.iconOnly,
        _responsive = _this$props.responsive,
        restTextProps = _this$props.textProps,
        fill = _this$props.fill,
        rest = _objectWithoutProperties(_this$props, _excluded);
      // Force responsive for "all" if `iconOnly = true`
      var responsive = iconOnly ? 'all' : _responsive;
      var classes = classNames('euiSuperUpdateButton', className);
      var sharedButtonProps = {
        color: needsUpdate || isLoading ? 'success' : 'primary',
        iconType: needsUpdate || isLoading ? 'kqlFunction' : 'refresh',
        isDisabled: isDisabled,
        onClick: onClick,
        isLoading: isLoading
      };
      var buttonContent = this.renderButtonContent();
      return ___EmotionJSX(EuiToolTip, _extends({
        ref: this.setTootipRef,
        content: this.renderTooltipContent(),
        position: "bottom"
      }, toolTipProps), ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiShowFor, {
        sizes: responsive || 'none'
      }, ___EmotionJSX(EuiButton, _extends({
        className: classes,
        minWidth: false
      }, sharedButtonProps, {
        fill: fill,
        textProps: _objectSpread(_objectSpread({}, restTextProps), {}, {
          className: classNames('euiScreenReaderOnly', restTextProps && restTextProps.className)
        })
      }, rest), buttonContent)), ___EmotionJSX(EuiHideFor, {
        sizes: responsive || 'none'
      }, ___EmotionJSX(EuiButton, _extends({
        className: classes,
        minWidth: 118
      }, sharedButtonProps, {
        fill: fill,
        textProps: restTextProps
      }, rest), buttonContent))));
    }
  }, {
    key: "renderButtonContent",
    value: function renderButtonContent() {
      var _this$props2 = this.props,
        children = _this$props2.children,
        isLoading = _this$props2.isLoading,
        needsUpdate = _this$props2.needsUpdate;
      if (children) {
        return children;
      }
      if (isLoading) {
        return ___EmotionJSX(EuiI18n, {
          token: "euiSuperUpdateButton.updatingButtonLabel",
          default: "Updating"
        });
      }
      if (needsUpdate) {
        return ___EmotionJSX(EuiI18n, {
          token: "euiSuperUpdateButton.updateButtonLabel",
          default: "Update"
        });
      }
      return ___EmotionJSX(EuiI18n, {
        token: "euiSuperUpdateButton.refreshButtonLabel",
        default: "Refresh"
      });
    }
  }, {
    key: "renderTooltipContent",
    value: function renderTooltipContent() {
      if (this.props.isDisabled) {
        return ___EmotionJSX(EuiI18n, {
          token: "euiSuperUpdateButton.cannotUpdateTooltip",
          default: "Cannot update"
        });
      }
      if (this.props.needsUpdate && !this.props.isLoading) {
        return ___EmotionJSX(EuiI18n, {
          token: "euiSuperUpdateButton.clickToApplyTooltip",
          default: "Click to apply"
        });
      }
    }
  }]);
}(Component);
_defineProperty(EuiSuperUpdateButton, "defaultProps", {
  needsUpdate: false,
  isLoading: false,
  isDisabled: false,
  showTooltip: false,
  responsive: ['xs', 's'],
  fill: true
});