import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { Component } from 'react';
export var EuiDelayRender = /*#__PURE__*/function (_Component) {
  function EuiDelayRender(props) {
    var _this;
    _classCallCheck(this, EuiDelayRender);
    _this = _callSuper(this, EuiDelayRender, [props]);
    _defineProperty(_this, "delayID", void 0);
    _defineProperty(_this, "toBeDelayed", true);
    _defineProperty(_this, "startDelaying", function () {
      window.clearTimeout(_this.delayID);
      _this.toBeDelayed = true;
      _this.delayID = window.setTimeout(_this.stopDelaying, _this.props.delay);
    });
    _defineProperty(_this, "stopDelaying", function () {
      window.clearTimeout(_this.delayID);
      _this.toBeDelayed = false;
      _this.shouldUpdate();
    });
    _this.state = {
      toggle: false
    };
    return _this;
  }
  _inherits(EuiDelayRender, _Component);
  return _createClass(EuiDelayRender, [{
    key: "shouldUpdate",
    value: function shouldUpdate() {
      this.setState(function (_ref) {
        var toggle = _ref.toggle;
        return {
          toggle: !toggle
        };
      });
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.startDelaying();
    }
  }, {
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate() {
      if (this.toBeDelayed) {
        this.startDelaying();
      }
      return true;
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.stopDelaying();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.toBeDelayed = true;
    }
  }, {
    key: "render",
    value: function render() {
      return !this.toBeDelayed ? this.props.children : null;
    }
  }]);
}(Component);
_defineProperty(EuiDelayRender, "defaultProps", {
  delay: 500
});