import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["align", "children", "className", "style", "compressed", "descriptionProps", "listItems", "textStyle", "titleProps", "type", "rowGutterSize", "columnGutterSize", "columnWidths"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles, useIsWithinBreakpoints } from '../../services';
import { EuiDescriptionListContext } from './description_list_context';
import { EuiDescriptionListTitle } from './description_list_title';
import { EuiDescriptionListDescription } from './description_list_description';
import { euiDescriptionListStyles } from './description_list.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDescriptionList = function EuiDescriptionList(_ref) {
  var _ref$align = _ref.align,
    align = _ref$align === void 0 ? 'left' : _ref$align,
    children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    descriptionProps = _ref.descriptionProps,
    listItems = _ref.listItems,
    _ref$textStyle = _ref.textStyle,
    textStyle = _ref$textStyle === void 0 ? 'normal' : _ref$textStyle,
    titleProps = _ref.titleProps,
    _ref$type = _ref.type,
    _type = _ref$type === void 0 ? 'row' : _ref$type,
    _ref$rowGutterSize = _ref.rowGutterSize,
    rowGutterSize = _ref$rowGutterSize === void 0 ? 's' : _ref$rowGutterSize,
    _ref$columnGutterSize = _ref.columnGutterSize,
    columnGutterSize = _ref$columnGutterSize === void 0 ? 's' : _ref$columnGutterSize,
    columnWidths = _ref.columnWidths,
    rest = _objectWithoutProperties(_ref, _excluded);
  var showResponsiveColumns = useIsWithinBreakpoints(['xs', 's']);
  var type = useMemo(function () {
    if (_type === 'responsiveColumn') {
      return showResponsiveColumns ? 'row' : 'column';
    } else {
      return _type;
    }
  }, [_type, showResponsiveColumns]);
  var styles = useEuiMemoizedStyles(euiDescriptionListStyles);
  var cssStyles = [styles.euiDescriptionList, styles[type], styles[align], type === 'column' && styles.rowGap[rowGutterSize], type === 'column' && styles.columnGap[columnGutterSize]];
  var inlineStyles = useMemo(function () {
    if (type === 'column' && columnWidths) {
      // Leave string values as is - e.g. if a consumer passes in a specific '200px' or 'minmax()'
      var convertNumbersToFr = function convertNumbersToFr(value) {
        return typeof value === 'number' ? "".concat(value, "fr") : value;
      };
      var titleWidth = convertNumbersToFr(columnWidths[0]);
      var descriptionWidth = convertNumbersToFr(columnWidths[1]);
      return _objectSpread({
        gridTemplateColumns: "".concat(titleWidth, " ").concat(descriptionWidth)
      }, style);
    }
    return style;
  }, [style, type, columnWidths]);
  var classes = classNames('euiDescriptionList', className);
  var renderedListItems = useMemo(function () {
    if (listItems) {
      return listItems.map(function (item, index) {
        return [___EmotionJSX(EuiDescriptionListTitle, _extends({
          key: "title-".concat(index)
        }, titleProps), item.title), ___EmotionJSX(EuiDescriptionListDescription, _extends({
          key: "description-".concat(index)
        }, descriptionProps), item.description)];
      });
    }
  }, [listItems, descriptionProps, titleProps]);
  return ___EmotionJSX(EuiDescriptionListContext.Provider, {
    value: {
      type: type,
      compressed: compressed,
      textStyle: textStyle,
      align: align,
      rowGutterSize: rowGutterSize
    }
  }, ___EmotionJSX("dl", _extends({
    className: classes,
    css: cssStyles,
    style: inlineStyles
  }, rest, {
    "data-type": _type
  }), listItems ? renderedListItems : children));
};