import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiDescriptionListContext } from './description_list_context';
import { euiDescriptionListTitleStyles } from './description_list_title.styles';

// Export required for correct inference by HOCs
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDescriptionListTitle = function EuiDescriptionListTitle(_ref) {
  var children = _ref.children,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiDescriptionListContext),
    type = _useContext.type,
    textStyle = _useContext.textStyle,
    compressed = _useContext.compressed,
    align = _useContext.align,
    rowGutterSize = _useContext.rowGutterSize;
  var styles = useEuiMemoizedStyles(euiDescriptionListTitleStyles);
  var conditionalStyles = compressed && textStyle !== 'reverse' ? [styles.fontStyles.compressed] : [styles.fontStyles[textStyle]];
  switch (type) {
    case 'inline':
      conditionalStyles = compressed ? [styles.inlineStyles.compressed] : [styles.inlineStyles.normal];
      break;
    case 'row':
      conditionalStyles.push(styles[rowGutterSize]);
      break;
    case 'column':
      if (align === 'center') {
        conditionalStyles.push(styles.right);
      }
      break;
  }
  var cssStyles = [styles.euiDescriptionList__title, styles[type]].concat(_toConsumableArray(conditionalStyles));
  var classes = classNames('euiDescriptionList__title', className);
  return ___EmotionJSX("dt", _extends({
    className: classes,
    css: cssStyles
  }, rest), children);
};