/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, euiTextBreakWord, logicalTextAlignCSS, logicalCSS } from '../../global_styling';
import { euiTitle } from '../title/title.styles';
export var euiDescriptionListTitleStyles = function euiDescriptionListTitleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  return {
    euiDescriptionList__title: /*#__PURE__*/css(euiTextBreakWord(), ";;label:euiDescriptionList__title;"),
    // Types
    row: /*#__PURE__*/css(";label:row;"),
    column: /*#__PURE__*/css(";label:column;"),
    inline: /*#__PURE__*/css("display:inline;border-radius:", euiTheme.border.radius.small, ";font-weight:", euiTheme.font.weight.medium, ";background-color:", colorMode === 'DARK' ? euiTheme.colors.lightShade : euiTheme.colors.lightestShade, ";", logicalCSS('margin-vertical', '0'), " ", logicalCSS('margin-horizontal', euiTheme.size.xs), " ", colorMode === 'DARK' && "color: ".concat(euiTheme.colors.title, ";"), "&:first-of-type{", logicalCSS('margin-left', '0'), ";};label:inline;"),
    // This nested block handles just the font styling based on compressed and reverse
    fontStyles: {
      normal: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xs'), ";;label:normal;"),
      reverse: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), ";;label:reverse;"),
      compressed: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xxs'), ";;label:compressed;")
    },
    // Inline types
    inlineStyles: {
      normal: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), " ", logicalCSS('padding-vertical', '1px'), " ", logicalCSS('padding-horizontal', euiTheme.size.xs), ";;label:normal;"),
      compressed: /*#__PURE__*/css("font-size:", euiFontSize(euiThemeContext, 'xs').fontSize, ";line-height:", euiTheme.font.lineHeightMultiplier, ";", logicalCSS('padding-vertical', '0'), " ", logicalCSS('padding-horizontal', euiTheme.size.xs), ";;label:compressed;")
    },
    // Alignment
    right: /*#__PURE__*/css(logicalTextAlignCSS('right'), ";;label:right;"),
    // Gutter
    // Add margin only to the non-first <dt>.
    s: /*#__PURE__*/css("&:not(:first-of-type){", logicalCSS('margin-top', euiTheme.size.s), ";};label:s;"),
    m: /*#__PURE__*/css("&:not(:first-of-type){", logicalCSS('margin-top', euiTheme.size.base), ";};label:m;")
  };
};