import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiDragDropContext } from './drag_drop_context';
import { euiDragDropReorder } from './services';
import { EuiDraggable } from './draggable';
import { EuiDroppable } from './droppable';
import { EuiPanel } from '../panel';
import { htmlIdGenerator } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
var makeId = htmlIdGenerator();
var makeList = function makeList(number) {
  var start = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
  return Array.from({
    length: number
  }, function (v, k) {
    return k + start;
  }).map(function (el) {
    return {
      content: "Item ".concat(el),
      id: makeId()
    };
  });
};
var DragAndDrop = function DragAndDrop() {
  var _useState = useState(makeList(3)),
    _useState2 = _slicedToArray(_useState, 2),
    list = _useState2[0],
    setList = _useState2[1];
  var onDragEnd = function onDragEnd(_ref) {
    var source = _ref.source,
      destination = _ref.destination;
    if (source && destination) {
      var items = euiDragDropReorder(list, source.index, destination.index);
      setList(items);
    }
  };
  return ___EmotionJSX(EuiDragDropContext, {
    onDragEnd: onDragEnd
  }, ___EmotionJSX(EuiDroppable, {
    droppableId: "DROPPABLE_AREA",
    spacing: "m",
    withPanel: true
  }, list.map(function (_ref2, idx) {
    var content = _ref2.content,
      id = _ref2.id;
    return ___EmotionJSX(EuiDraggable, {
      spacing: "m",
      key: id,
      index: idx,
      draggableId: id,
      "data-test-subj": "cy-draggable-".concat(idx)
    }, function (provided, state) {
      return ___EmotionJSX(EuiPanel, {
        hasShadow: state.isDragging
      }, content, state.isDragging && ' ✨');
    });
  })));
};
beforeEach(function () {
  cy.realMount(___EmotionJSX(DragAndDrop, null));
});
describe('EuiDragDrop', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when an item is in draggable state', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-1"]').should('have.focus');
      cy.checkAxe();
    });
    it('has zero violations when an item has been reordered and dropped', function () {
      cy.repeatRealPress('Tab');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-1"]').should('have.focus');
      cy.realPress('ArrowDown');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-2"]').should('have.focus');
      cy.realPress('Space');
      cy.repeatRealPress('ArrowUp');
      cy.realPress('Space');
      cy.get('div[data-test-subj="cy-draggable-0"]').should('have.focus');
      cy.checkAxe();
    });
  });
});