import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["droppableId", "direction", "isDropDisabled", "children", "className", "cloneDraggables", "spacing", "style", "type", "withPanel", "grow", "data-test-subj"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import { Droppable } from '@hello-pangea/dnd';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiPanel } from '../panel';
import { EuiDragDropContextContext } from './drag_drop_context';
import { euiDroppableStyles } from './droppable.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SPACINGS = ['none', 's', 'm', 'l'];
export var EuiDroppableContext = /*#__PURE__*/React.createContext({
  cloneItems: false
});
export var EuiDroppable = function EuiDroppable(_ref) {
  var droppableId = _ref.droppableId,
    direction = _ref.direction,
    _ref$isDropDisabled = _ref.isDropDisabled,
    isDropDisabled = _ref$isDropDisabled === void 0 ? false : _ref$isDropDisabled,
    children = _ref.children,
    className = _ref.className,
    _ref$cloneDraggables = _ref.cloneDraggables,
    cloneDraggables = _ref$cloneDraggables === void 0 ? false : _ref$cloneDraggables,
    _ref$spacing = _ref.spacing,
    spacing = _ref$spacing === void 0 ? 'none' : _ref$spacing,
    style = _ref.style,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'EUI_DEFAULT' : _ref$type,
    _ref$withPanel = _ref.withPanel,
    withPanel = _ref$withPanel === void 0 ? false : _ref$withPanel,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? false : _ref$grow,
    _ref$dataTestSubj = _ref['data-test-subj'],
    dataTestSubj = _ref$dataTestSubj === void 0 ? 'droppable' : _ref$dataTestSubj,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiDragDropContextContext),
    isDraggingType = _useContext.isDraggingType;
  var dropIsDisabled = cloneDraggables ? true : isDropDisabled;
  var styles = useEuiMemoizedStyles(euiDroppableStyles);
  return ___EmotionJSX(Droppable, _extends({
    isDropDisabled: dropIsDisabled,
    droppableId: droppableId,
    direction: direction,
    type: type
  }, rest), function (provided, snapshot) {
    var isDraggingOver = snapshot.isDraggingOver;
    var PanelOrDiv = withPanel ? EuiPanel : 'div';
    var panelOrDivProps = withPanel ? {
      panelRef: provided.innerRef,
      hasShadow: true,
      paddingSize: 'none'
    } : {
      ref: provided.innerRef
    };
    var cssStyles = [styles.euiDroppable, isDraggingType === type && !dropIsDisabled && styles.isDragging, isDraggingOver && styles.isDraggingOver, grow ? styles.grow : styles.noGrow, styles.spacing[spacing]];
    var classes = classNames('euiDroppable', {
      'euiDroppable-isDisabled': dropIsDisabled
    }, className);
    var DroppableElement = typeof children === 'function' ? children(provided, snapshot) : children;
    return ___EmotionJSX(PanelOrDiv, _extends({}, provided.droppableProps, panelOrDivProps, {
      style: style,
      "data-test-subj": dataTestSubj,
      className: classes,
      css: cssStyles
    }), ___EmotionJSX(EuiDroppableContext.Provider, {
      value: {
        cloneItems: cloneDraggables
      }
    }, DroppableElement), ___EmotionJSX("div", {
      className: "euiDroppable__placeholder",
      hidden: cloneDraggables
    }, provided.placeholder));
  });
};