/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React from 'react';
import { EuiButton } from '../button';
import { EuiEmptyPrompt } from './empty_prompt';
import { EuiLink } from '../link';
import { EuiTitle } from '../title';
import { jsx as ___EmotionJSX } from "@emotion/react";
beforeEach(function () {
  var addCaseSpy = cy.spy().as('addCaseSpy');
  var addLinkSpy = cy.spy().as('addLinkSpy');
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount(___EmotionJSX(EuiEmptyPrompt, {
    iconType: "logoSecurity",
    title: ___EmotionJSX("h2", null, "Start adding cases"),
    body: ___EmotionJSX("p", null, "Add a new case or change your filter settings."),
    actions: ___EmotionJSX(EuiButton, {
      color: "primary",
      onClick: addCaseSpy,
      fill: true
    }, "Add a case"),
    footer: ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiTitle, {
      size: "xxs"
    }, ___EmotionJSX("h3", null, "Want to learn more?")), ___EmotionJSX(EuiLink, {
      href: "#",
      onClick: addLinkSpy
    }, "Read the docs"))
  }));
});
describe('EuiEmptyPrompt', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations after clicking Add a case button', function () {
      cy.get('button.euiButton').contains('Add a case').realClick();
      cy.get('@addCaseSpy').should('have.been.called');
      cy.checkAxe();
    });
    it('has zero violations after clicking Read the docs link', function () {
      cy.get('a.euiLink').contains('Read the docs').realClick();
      cy.get('@addLinkSpy').should('have.been.called');
      cy.checkAxe();
    });
  });
});