import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["icon", "iconType", "iconColor", "title", "titleSize", "paddingSize", "body", "actions", "className", "layout", "hasBorder", "color", "footer"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiTitle } from '../title';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { EuiSpacer } from '../spacer';
import { EuiIcon } from '../icon';
import { isNamedColor } from '../icon/named_colors';
import { EuiText } from '../text';
import { EuiPanel } from '../panel/panel';
import { euiEmptyPromptStyles } from './empty_prompt.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var PADDING_SIZES = ['none', 's', 'm', 'l'];
export var EuiEmptyPrompt = function EuiEmptyPrompt(_ref) {
  var icon = _ref.icon,
    iconType = _ref.iconType,
    _iconColor = _ref.iconColor,
    title = _ref.title,
    _ref$titleSize = _ref.titleSize,
    titleSize = _ref$titleSize === void 0 ? 'm' : _ref$titleSize,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    body = _ref.body,
    actions = _ref.actions,
    className = _ref.className,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    hasBorder = _ref.hasBorder,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'transparent' : _ref$color,
    footer = _ref.footer,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiEmptyPrompt', className);
  var styles = useEuiMemoizedStyles(euiEmptyPromptStyles);
  var cssStyles = [styles.euiEmptyPrompt, styles[layout]];
  var mainStyles = [styles.main.euiEmptyPrompt__main, styles.main[layout], styles.main[paddingSize], layout === 'horizontal' && styles.main.horizontalPadding[paddingSize]];
  var contentStyles = [styles.content.euiEmptyPrompt__content, styles.content[layout]];

  // Default the iconColor to `subdued`,
  // otherwise try to match the iconColor with the panel color unless iconColor is specified
  var iconColor = _iconColor !== null && _iconColor !== void 0 ? _iconColor : isNamedColor(color) ? color : 'subdued';
  var iconNode = useMemo(function () {
    if (!iconType && !icon) return null;
    var iconStyles = [styles.icon.euiEmptyPrompt__icon, styles.icon[layout]];
    return ___EmotionJSX("div", {
      className: "euiEmptyPrompt__icon",
      css: iconStyles
    }, iconType ? ___EmotionJSX(EuiIcon, {
      type: iconType,
      size: "xxl",
      color: iconColor
    }) : icon);
  }, [icon, iconType, iconColor, layout, styles.icon]);
  var actionsNode = useMemo(function () {
    if (!actions) return null;
    if (Array.isArray(actions)) {
      var actionStyles = [styles.actions.euiEmptyPrompt__actions, styles.actions[layout]];
      return ___EmotionJSX(EuiFlexGroup, {
        className: "euiEmptyPrompt__actions",
        css: actionStyles,
        gutterSize: "m",
        alignItems: "center",
        justifyContent: "center",
        direction: layout === 'vertical' ? 'column' : 'row'
      }, actions.map(function (action, index) {
        return ___EmotionJSX(EuiFlexItem, {
          key: index,
          grow: false
        }, action);
      }));
    } else {
      return actions;
    }
  }, [actions, layout, styles.actions]);
  var footerNode = useMemo(function () {
    if (!footer) return null;
    var footerStyles = [styles.footer.euiEmptyPrompt__footer, styles.footer[paddingSize], styles.footer[color], color === 'transparent' && !hasBorder && styles.footer.roundedBorders];
    return ___EmotionJSX("div", {
      className: "euiEmptyPrompt__footer",
      css: footerStyles
    }, footer);
  }, [footer, paddingSize, color, hasBorder, styles.footer]);
  return ___EmotionJSX(EuiPanel, _extends({
    css: cssStyles,
    className: classes,
    color: color,
    paddingSize: "none",
    grow: false,
    hasBorder: hasBorder
  }, rest), ___EmotionJSX("div", {
    className: "euiEmptyPrompt__main",
    css: mainStyles
  }, iconNode, ___EmotionJSX("div", {
    className: "euiEmptyPrompt__content",
    css: contentStyles
  }, title && ___EmotionJSX(EuiTitle, {
    size: titleSize
  }, title), title && body && ___EmotionJSX(EuiSpacer, {
    size: "m"
  }), body && ___EmotionJSX(EuiText, {
    color: "subdued"
  }, body), actionsNode && (body || title) && ___EmotionJSX(EuiSpacer, {
    size: "l"
  }), actionsNode)), footerNode);
};