import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
var _excluded = ["children"],
  _excluded2 = ["errorMessage", "className", "data-test-subj"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiTitle } from '../title';
import { EuiCodeBlock } from '../code';
import { EuiI18n } from '../i18n';
import { euiErrorBoundaryStyles } from './error_boundary.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiErrorBoundary = /*#__PURE__*/function (_Component) {
  function EuiErrorBoundary(props) {
    var _this;
    _classCallCheck(this, EuiErrorBoundary);
    _this = _callSuper(this, EuiErrorBoundary, [props]);
    var errorState = {
      hasError: false,
      errorMessage: undefined
    };
    _this.state = errorState;
    return _this;
  }
  _inherits(EuiErrorBoundary, _Component);
  return _createClass(EuiErrorBoundary, [{
    key: "componentDidCatch",
    value: function componentDidCatch(error) {
      var _this$props$onError, _this$props;
      // Display fallback UI
      // Only Chrome includes the `message` property as part of `stack`.
      // For consistency, rebuild the full error text from the Error subparts.
      var message = error.message,
        stack = error.stack;
      var idx = (stack === null || stack === void 0 ? void 0 : stack.indexOf(message)) || -1;
      var stackStr = idx > -1 ? stack === null || stack === void 0 ? void 0 : stack.substring(idx + message.length + 1) : stack;
      var errorMessage = "Error: ".concat(message, "\n").concat(stackStr);
      this.setState({
        hasError: true,
        errorMessage: errorMessage
      });

      // Pass back the error to the consumer
      (_this$props$onError = (_this$props = this.props).onError) === null || _this$props$onError === void 0 || _this$props$onError.call(_this$props, error);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
        children = _this$props2.children,
        rest = _objectWithoutProperties(_this$props2, _excluded);
      var _this$state = this.state,
        hasError = _this$state.hasError,
        errorMessage = _this$state.errorMessage;
      if (hasError) {
        // You can render any custom fallback UI
        return ___EmotionJSX(EuiErrorMessage, _extends({}, rest, {
          errorMessage: errorMessage
        }));
      }
      return children;
    }
  }]);
}(Component);

/**
 * Split out into a separate styling-only component for easier use of hooks,
 * and also for internal re-use by EUI's docs/playgrounds
 */
export var EuiErrorMessage = function EuiErrorMessage(_ref) {
  var errorMessage = _ref.errorMessage,
    className = _ref.className,
    dataTestSubj = _ref['data-test-subj'],
    rest = _objectWithoutProperties(_ref, _excluded2);
  var styles = useEuiMemoizedStyles(euiErrorBoundaryStyles);
  return ___EmotionJSX("div", _extends({
    css: styles.euiErrorBoundary,
    className: classNames('euiErrorBoundary', className),
    "data-test-subj": classNames('euiErrorBoundary', dataTestSubj)
  }, rest), ___EmotionJSX(EuiCodeBlock, null, ___EmotionJSX(EuiTitle, {
    size: "xs"
  }, ___EmotionJSX("p", null, ___EmotionJSX(EuiI18n, {
    token: "euiErrorBoundary.error",
    default: "Error"
  }))), errorMessage));
};