/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
import { transparentize } from '../../services';
export var euiErrorBoundaryStyles = function euiErrorBoundaryStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  var color1 = transparentize(euiTheme.colors.danger, 0.25);
  var color2 = transparentize(euiTheme.colors.danger, 0.05);
  return {
    euiErrorBoundary: /*#__PURE__*/css("background-image:repeating-linear-gradient(\n        45deg,\n        ", color1, ",\n        ", color1, " 1px,\n        ", color2, " 1px,\n        ", color2, " 19px\n      );background-size:54px 54px;", logicalCSS('padding-horizontal', euiTheme.size.base), " ", logicalCSS('padding-vertical', euiTheme.size.base), ";;label:euiErrorBoundary;")
  };
};