import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiExpression } from './expression';
import { EuiFieldNumber, EuiSelect } from '../form';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { EuiPanel } from '../panel';
import { EuiPopover, EuiPopoverTitle } from '../popover';
import { useGeneratedHtmlId } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
describe('EuiExpression', function () {
  var BaseExpression = function BaseExpression() {
    var _useState = useState({
        isOpen: false,
        value: 'count()'
      }),
      _useState2 = _slicedToArray(_useState, 2),
      example1 = _useState2[0],
      setExample1 = _useState2[1];
    var _useState3 = useState({
        value: 100,
        description: 'Is above'
      }),
      _useState4 = _slicedToArray(_useState3, 2),
      example2 = _useState4[0],
      setExample2 = _useState4[1];
    var expressionPopoverId__1 = useGeneratedHtmlId({
      prefix: 'expressionPopover',
      suffix: 'first'
    });
    var expressionPopoverId__2 = useGeneratedHtmlId({
      prefix: 'expressionPopover',
      suffix: 'second'
    });
    var openExample1 = function openExample1() {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        isOpen: true
      }));
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        isOpen: false
      }));
    };
    var closeExample1 = function closeExample1() {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        isOpen: false
      }));
    };
    var openExample2 = function openExample2() {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        isOpen: false
      }));
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        isOpen: true
      }));
    };
    var closeExample2 = function closeExample2() {
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        isOpen: false
      }));
    };
    var changeExample1 = function changeExample1(event) {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        value: event.target.value
      }));
    };
    var changeExample2Value = function changeExample2Value(e) {
      var sanitizedValue = parseInt(e.target.value, 10);
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        value: isNaN(sanitizedValue) ? '' : sanitizedValue
      }));
    };
    var changeExample2Description = function changeExample2Description(event) {
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        description: event.target.value
      }));
    };
    var renderPopover1 = function renderPopover1() {
      return ___EmotionJSX("div", {
        "data-test-subj": "cy-expression-popover-1"
      }, ___EmotionJSX(EuiPopoverTitle, null, "When"), ___EmotionJSX(EuiSelect, {
        compressed: true,
        value: example1.value,
        onChange: changeExample1,
        options: [{
          value: 'count()',
          text: 'count()'
        }, {
          value: 'average()',
          text: 'average()'
        }, {
          value: 'sum()',
          text: 'sum()'
        }, {
          value: 'median()',
          text: 'median()'
        }, {
          value: 'min()',
          text: 'min()'
        }, {
          value: 'max()',
          text: 'max()'
        }]
      }));
    };
    var renderPopover2 = function renderPopover2() {
      return ___EmotionJSX("div", {
        "data-test-subj": "cy-expression-popover-2"
      }, ___EmotionJSX(EuiFlexGroup, {
        gutterSize: "s"
      }, ___EmotionJSX(EuiFlexItem, {
        grow: false,
        style: {
          width: 150
        }
      }, ___EmotionJSX(EuiSelect, {
        compressed: true,
        value: example2.description,
        onChange: changeExample2Description,
        options: [{
          value: 'Is above',
          text: 'Is above'
        }, {
          value: 'Is below',
          text: 'Is below'
        }, {
          value: 'Is exactly',
          text: 'Is exactly'
        }]
      })), ___EmotionJSX(EuiFlexItem, {
        grow: false,
        style: {
          width: 100
        }
      }, ___EmotionJSX(EuiFieldNumber, {
        compressed: true,
        value: example2.value,
        onChange: changeExample2Value
      }))));
    };
    return ___EmotionJSX(EuiPanel, null, ___EmotionJSX(EuiFlexGroup, {
      gutterSize: "s"
    }, ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, ___EmotionJSX(EuiPopover, {
      id: expressionPopoverId__1,
      button: ___EmotionJSX(EuiExpression, {
        description: "when",
        value: example1.value,
        isActive: example1.isOpen,
        onClick: openExample1
      }),
      isOpen: example1.isOpen,
      closePopover: closeExample1,
      panelPaddingSize: "s",
      anchorPosition: "downLeft"
    }, renderPopover1())), ___EmotionJSX(EuiFlexItem, {
      grow: false
    }, ___EmotionJSX(EuiPopover, {
      id: expressionPopoverId__2,
      panelPaddingSize: "s",
      button: ___EmotionJSX(EuiExpression, {
        description: example2.description,
        value: example2.value,
        isActive: example2.isOpen,
        onClick: openExample2
      }),
      isOpen: example2.isOpen,
      closePopover: closeExample2,
      anchorPosition: "downLeft"
    }, renderPopover2()))));
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(BaseExpression, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when count popover is open', function () {
      cy.get('button').contains(/When count\(\)/i).realClick();
      cy.get('div[data-test-subj="cy-expression-popover-1"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when is above popover is open', function () {
      cy.get('button').contains(/Is above 100/i).realClick();
      cy.get('div[data-test-subj="cy-expression-popover-2"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when first popover is interacted with by keyboard', function () {
      cy.get('button').contains(/When count\(\)/i).focus();
      cy.realPress('Enter');
      cy.get('div[data-test-subj="cy-expression-popover-1"]').should('exist');
      cy.realPress('Tab');
      cy.realPress(['a', 'v', 'g']);
      cy.realPress('Escape');
      cy.get('button').contains(/When average\(\)/i).should('have.focus');
      cy.checkAxe();
    });
    it('has zero violations when second popover is interacted with by keyboard', function () {
      cy.get('button').contains(/Is above 100/i).focus();
      cy.realPress('Enter');
      cy.get('div[data-test-subj="cy-expression-popover-2"]').should('exist');
      cy.realPress('Tab');
      cy.realPress(['I', 's', ' ', 'e']);
      cy.realPress('Tab');
      cy.repeatRealPress('Delete', 3);
      cy.realPress(['5', '0', '0']);
      cy.realPress('Escape');
      cy.get('button').contains(/Is exactly 500/i).should('have.focus');
      cy.checkAxe();
    });
  });
});