import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "icon", "isDisabled", "isLoading", "isSelected", "quantity", "buttonRef"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { EuiNotificationBadge } from '../badge';
import { EuiLoadingSpinner } from '../loading';
import { EuiInnerText } from '../inner_text';
import { useEuiTheme, cloneElementWithCss } from '../../services';
import { euiFacetButtonStyles, euiFacetButtonTextStyles, euiFacetButtonIconStyles, euiFacetButtonQuantityStyles, euiFacetButtonLoadingSpinnerStyles } from './facet_button.styles';
import { EuiButtonDisplay, isButtonDisabled } from '../button/button_display/_button_display';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFacetButton = function EuiFacetButton(_ref) {
  var children = _ref.children,
    className = _ref.className,
    icon = _ref.icon,
    _ref$isDisabled = _ref.isDisabled,
    isDisabled = _ref$isDisabled === void 0 ? false : _ref$isDisabled,
    _ref$isLoading = _ref.isLoading,
    isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    quantity = _ref.quantity,
    buttonRef = _ref.buttonRef,
    rest = _objectWithoutProperties(_ref, _excluded);
  // If in the loading state, force disabled to true
  isDisabled = isButtonDisabled({
    isDisabled: isDisabled,
    isLoading: isLoading
  });
  var selection = isSelected ? 'isSelected' : 'unSelected';
  var classes = classNames('euiFacetButton', className);
  var theme = useEuiTheme();
  var styles = euiFacetButtonStyles(theme);
  var cssStyles = [styles.euiFacetButton];
  var textStyles = euiFacetButtonTextStyles(theme);
  var cssTextStyles = [textStyles.euiFacetButton__text, textStyles[selection]];
  var quantityStyles = euiFacetButtonQuantityStyles();
  var cssQuantityStyles = [quantityStyles.euiFacetButton__quantity, isDisabled && quantityStyles.isDisabled];
  var iconStyles = euiFacetButtonIconStyles();
  var cssIconStyles = [iconStyles.euiFacetButton__icon, isDisabled && quantityStyles.isDisabled];
  var loadingSpinnerStyles = euiFacetButtonLoadingSpinnerStyles();
  var cssLoadingSpinnerStyles = [loadingSpinnerStyles.euiFacetButton__loadingSpinner];

  // Add quantity number if provided or loading indicator
  var buttonQuantity;
  if (isLoading) {
    buttonQuantity = ___EmotionJSX(EuiLoadingSpinner, {
      css: cssLoadingSpinnerStyles,
      size: "m"
    });
  } else if (typeof quantity === 'number') {
    buttonQuantity = ___EmotionJSX(EuiNotificationBadge, {
      css: cssQuantityStyles,
      className: "euiFacetButton__quantity",
      size: "m",
      color: !isSelected || isDisabled ? 'subdued' : 'accent'
    }, quantity);
  }

  // Add an icon to the button if one exists.
  var buttonIcon;
  if ( /*#__PURE__*/React.isValidElement(icon)) {
    buttonIcon = cloneElementWithCss(icon, {
      css: cssIconStyles,
      className: 'euiFacetButton__icon'
    });
  }
  return ___EmotionJSX(EuiInnerText, null, function (ref, innerText) {
    return ___EmotionJSX(EuiButtonDisplay, _extends({
      className: classes,
      css: cssStyles,
      isDisabled: isDisabled,
      ref: buttonRef,
      title: rest['aria-label'] || innerText,
      size: "s"
    }, rest), buttonIcon, ___EmotionJSX("span", {
      css: cssTextStyles,
      className: "euiFacetButton__text",
      "data-text": innerText,
      ref: ref
    }, children), buttonQuantity);
  });
};