import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "layout", "gutterSize"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { euiFacetGroupStyles } from './facet_group.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var LAYOUTS = ['vertical', 'horizontal'];
export var GUTTER_SIZES = ['none', 's', 'm', 'l'];
export var EuiFacetGroup = function EuiFacetGroup(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$layout = _ref.layout,
    layout = _ref$layout === void 0 ? 'vertical' : _ref$layout,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'm' : _ref$gutterSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var theme = useEuiTheme();
  var styles = euiFacetGroupStyles(theme, layout);
  var cssStyles = [styles.euiFacetGroup, styles[gutterSize], styles[layout]];
  var classes = classNames('euiFacetGroup', className);
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: cssStyles
  }, rest), children);
};