import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "iconType", "iconSide", "color", "badgeColor", "hasActiveFilters", "numFilters", "numActiveFilters", "isDisabled", "isSelected", "type", "grow", "withNext", "textProps", "contentProps"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { useEuiI18n } from '../i18n';
import { useInnerText } from '../inner_text';
import { EuiNotificationBadge } from '../badge';
import { EuiButtonEmpty } from '../button/button_empty';
import { euiFilterButtonStyles, euiFilterButtonChildStyles } from './filter_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFilterButton = function EuiFilterButton(_ref) {
  var children = _ref.children,
    className = _ref.className,
    iconType = _ref.iconType,
    _ref$iconSide = _ref.iconSide,
    iconSide = _ref$iconSide === void 0 ? 'right' : _ref$iconSide,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'text' : _ref$color,
    _ref$badgeColor = _ref.badgeColor,
    badgeColor = _ref$badgeColor === void 0 ? 'accent' : _ref$badgeColor,
    hasActiveFilters = _ref.hasActiveFilters,
    numFilters = _ref.numFilters,
    numActiveFilters = _ref.numActiveFilters,
    isDisabled = _ref.isDisabled,
    isSelected = _ref.isSelected,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'button' : _ref$type,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    withNext = _ref.withNext,
    textProps = _ref.textProps,
    contentProps = _ref.contentProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var numFiltersDefined = numFilters != null; // != instead of !== to allow for null and undefined
  var numActiveFiltersDefined = numActiveFilters != null && numActiveFilters > 0;
  var euiTheme = useEuiTheme();
  var styles = euiFilterButtonStyles(euiTheme);
  var cssStyles = [styles.euiFilterButton, withNext && styles.withNext, !grow && styles.noGrow, hasActiveFilters && styles.hasActiveFilters, numFiltersDefined && styles.hasNotification];
  var _euiFilterButtonChild = euiFilterButtonChildStyles(euiTheme),
    contentStyles = _euiFilterButtonChild.content,
    textStyles = _euiFilterButtonChild.text,
    notificationStyles = _euiFilterButtonChild.notification;
  var classes = classNames('euiFilterButton', {
    'euiFilterButton-isSelected': isSelected,
    'euiFilterButton-hasActiveFilters': hasActiveFilters,
    'euiFilterButton-hasNotification': numFiltersDefined
  }, className);

  /**
   * Badge
   */
  var showBadge = numFiltersDefined || numActiveFiltersDefined;
  var badgeCount = numActiveFilters || numFilters;
  var activeBadgeLabel = useEuiI18n('euiFilterButton.filterBadgeActiveAriaLabel', '{count} active filters', {
    count: badgeCount
  });
  var availableBadgeLabel = useEuiI18n('euiFilterButton.filterBadgeAvailableAriaLabel', '{count} available filters', {
    count: badgeCount
  });
  var badgeContent = showBadge && ___EmotionJSX(EuiNotificationBadge, {
    className: "euiFilterButton__notification",
    css: [notificationStyles.euiFilterButton__notification, isDisabled && notificationStyles.disabled, ";label:badgeContent;"],
    "aria-label": hasActiveFilters ? activeBadgeLabel : availableBadgeLabel,
    color: isDisabled || !hasActiveFilters ? 'subdued' : badgeColor,
    role: "marquee" // https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/marquee_role
  }, badgeCount);

  /**
   * Text
   */
  var buttonTextClassNames = classNames('euiFilterButton__text', {
    'euiFilterButton__text-hasNotification': showBadge
  }, textProps && textProps.className);
  var textCssStyles = [textStyles.euiFilterButton__text, showBadge && textStyles.hasNotification, textProps && textProps.css];
  var _useInnerText = useInnerText(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  var dataText = children && typeof children === 'string' ? children : innerText;
  var textContent = ___EmotionJSX("span", _extends({
    ref: ref,
    "data-text": dataText,
    title: dataText
  }, textProps, {
    className: buttonTextClassNames,
    css: textCssStyles
  }), children);
  return ___EmotionJSX(EuiButtonEmpty, _extends({
    className: classes,
    css: cssStyles,
    color: color,
    isDisabled: isDisabled,
    iconSide: iconSide,
    iconType: iconType,
    type: type,
    textProps: false,
    contentProps: _objectSpread(_objectSpread({}, contentProps), {}, {
      css: [contentStyles.euiFilterButton__content, iconType && contentStyles.hasIcon, contentProps === null || contentProps === void 0 ? void 0 : contentProps.css]
    })
  }, rest), textContent, badgeContent);
};