import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["theme", "children", "className", "disabled", "checked", "isFocused", "showIcons", "toolTipContent", "toolTipProps", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component, createRef } from 'react';
import classNames from 'classnames';
import { withEuiTheme } from '../../services';
import { EuiFlexGroup, EuiFlexItem } from '../flex';
import { EuiToolTip } from '../tool_tip';
import { EuiIcon } from '../icon';
import { euiFilterSelectItemStyles } from './filter_select_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var resolveIconAndColor = function resolveIconAndColor(checked) {
  if (!checked) {
    return {
      icon: 'empty'
    };
  }
  return checked === 'on' ? {
    icon: 'check',
    color: 'text'
  } : {
    icon: 'cross',
    color: 'text'
  };
};

/**
 * TODO: This component should removed in favor of EuiSelectable usage
 * once EuiComboBox has been converted to dogfood EuiSelectable.
 *
 * @deprecated - Use EuiSelectable instead
 */
export var EuiFilterSelectItemClass = /*#__PURE__*/function (_Component) {
  function EuiFilterSelectItemClass() {
    var _this;
    _classCallCheck(this, EuiFilterSelectItemClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFilterSelectItemClass, [].concat(args));
    _defineProperty(_this, "buttonRef", null);
    _defineProperty(_this, "tooltipRef", /*#__PURE__*/createRef());
    _defineProperty(_this, "state", {
      hasFocus: false
    });
    _defineProperty(_this, "focus", function () {
      if (_this.buttonRef) {
        _this.buttonRef.focus();
      }
    });
    _defineProperty(_this, "toggleToolTip", function (isFocused) {
      if (isFocused) {
        var _this$tooltipRef;
        (_this$tooltipRef = _this.tooltipRef) === null || _this$tooltipRef === void 0 || (_this$tooltipRef = _this$tooltipRef.current) === null || _this$tooltipRef === void 0 || _this$tooltipRef.showToolTip();
      } else {
        var _this$tooltipRef2;
        (_this$tooltipRef2 = _this.tooltipRef) === null || _this$tooltipRef2 === void 0 || (_this$tooltipRef2 = _this$tooltipRef2.current) === null || _this$tooltipRef2 === void 0 || _this$tooltipRef2.hideToolTip();
      }
    });
    _defineProperty(_this, "hasFocus", function () {
      return _this.state.hasFocus;
    });
    return _this;
  }
  _inherits(EuiFilterSelectItemClass, _Component);
  return _createClass(EuiFilterSelectItemClass, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        theme = _this$props.theme,
        children = _this$props.children,
        className = _this$props.className,
        disabled = _this$props.disabled,
        checked = _this$props.checked,
        isFocused = _this$props.isFocused,
        showIcons = _this$props.showIcons,
        toolTipContent = _this$props.toolTipContent,
        toolTipProps = _this$props.toolTipProps,
        style = _this$props.style,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var styles = euiFilterSelectItemStyles(theme);
      var cssStyles = [styles.euiFilterSelectItem, isFocused && styles.isFocused];
      var classes = classNames('euiFilterSelectItem', className);
      var hasToolTip =
      // we're using isValidElement here as EuiToolTipAnchor uses
      // cloneElement to enhance the element with required attributes
      /*#__PURE__*/React.isValidElement(children) && !disabled && toolTipContent;
      var anchorProps = undefined;
      if (hasToolTip) {
        var _toolTipProps$anchorP, _toolTipProps$anchorP2;
        var anchorStyles = toolTipProps !== null && toolTipProps !== void 0 && (_toolTipProps$anchorP = toolTipProps.anchorProps) !== null && _toolTipProps$anchorP !== void 0 && _toolTipProps$anchorP.style ? _objectSpread(_objectSpread({}, toolTipProps === null || toolTipProps === void 0 || (_toolTipProps$anchorP2 = toolTipProps.anchorProps) === null || _toolTipProps$anchorP2 === void 0 ? void 0 : _toolTipProps$anchorP2.style), style) : style;
        anchorProps = toolTipProps !== null && toolTipProps !== void 0 && toolTipProps.anchorProps ? _objectSpread(_objectSpread({}, toolTipProps.anchorProps), {}, {
          style: anchorStyles
        }) : {
          style: style
        };
        this.toggleToolTip(isFocused !== null && isFocused !== void 0 ? isFocused : false);
      }
      var iconNode;
      if (showIcons) {
        var _resolveIconAndColor = resolveIconAndColor(checked),
          icon = _resolveIconAndColor.icon,
          color = _resolveIconAndColor.color;
        iconNode = ___EmotionJSX(EuiFlexItem, {
          grow: false
        }, ___EmotionJSX(EuiIcon, {
          color: color,
          type: icon
        }));
      }
      var optionItem = ___EmotionJSX("button", _extends({
        ref: function ref(_ref) {
          return _this2.buttonRef = _ref;
        },
        role: "option",
        type: "button",
        "aria-selected": isFocused,
        className: classes,
        css: cssStyles,
        disabled: disabled,
        "aria-disabled": disabled,
        style: !hasToolTip ? style : undefined
      }, rest), ___EmotionJSX(EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        component: "span",
        responsive: false
      }, iconNode, ___EmotionJSX(EuiFlexItem, {
        className: "euiFilterSelectItem__content eui-textTruncate",
        component: "span"
      }, children)));
      return hasToolTip ? ___EmotionJSX(EuiToolTip, _extends({
        ref: this.tooltipRef,
        display: "block",
        content: toolTipContent,
        position: "left"
      }, toolTipProps, {
        anchorProps: anchorProps
      }), optionItem) : optionItem;
    }
  }]);
}(Component);

/**
 * @deprecated - Use EuiSelectable instead
 */
_defineProperty(EuiFilterSelectItemClass, "defaultProps", {
  showIcons: true
});
export var EuiFilterSelectItem = withEuiTheme(EuiFilterSelectItemClass);