import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "style", "gutterSize", "direction", "alignItems", "responsive", "columns", "component"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { euiFlexGridStyles } from './flex_grid.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var DIRECTIONS = ['row', 'column'];
export var ALIGN_ITEMS = ['stretch', 'start', 'end', 'center', 'baseline'];
export var GUTTER_SIZES = ['none', 's', 'm', 'l', 'xl'];
export var EuiFlexGrid = function EuiFlexGrid(_ref) {
  var children = _ref.children,
    className = _ref.className,
    style = _ref.style,
    _ref$gutterSize = _ref.gutterSize,
    gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
    _ref$direction = _ref.direction,
    direction = _ref$direction === void 0 ? 'row' : _ref$direction,
    _ref$alignItems = _ref.alignItems,
    alignItems = _ref$alignItems === void 0 ? 'stretch' : _ref$alignItems,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? true : _ref$responsive,
    _ref$columns = _ref.columns,
    columns = _ref$columns === void 0 ? 1 : _ref$columns,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiFlexGrid', className);
  var styles = useEuiMemoizedStyles(euiFlexGridStyles);
  var cssStyles = [styles.euiFlexGrid, styles.gutterSizes[gutterSize], styles.direction[direction], styles.alignItems[alignItems], styles.columnCount[columns], responsive && styles.responsive];
  var columnDirectionStyles = useMemo(function () {
    if (direction === 'column') {
      var rowsToRender = Math.ceil(React.Children.count(children) / columns);
      return {
        gridTemplateRows: "repeat(".concat(rowsToRender, ", 1fr)")
      };
    }
  }, [direction, columns, children]);
  return ___EmotionJSX(Component, _extends({
    css: cssStyles,
    className: classes,
    style: columnDirectionStyles ? _objectSpread(_objectSpread({}, style), columnDirectionStyles) : style
  }, rest), children);
};