import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "grow", "component"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, forwardRef } from 'react';
import classNames from 'classnames';
import { euiFlexItemStyles as styles } from './flex_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var VALID_GROW_VALUES = [null, undefined, true, false, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
var EuiFlexItemInternal = function EuiFlexItemInternal(_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    _ref$component = _ref.component,
    component = _ref$component === void 0 ? 'div' : _ref$component,
    rest = _objectWithoutProperties(_ref, _excluded);
  useEffect(function () {
    if (VALID_GROW_VALUES.indexOf(grow) === -1) {
      throw new Error("Prop `grow` passed to `EuiFlexItem` must be a boolean or an integer between 0 and 10, received `".concat(grow, "`"));
    }
  }, [grow]);
  var cssStyles = [styles.euiFlexItem, !grow ? styles.growZero : styles.grow, grow && (typeof grow === 'number' ? styles.growSizes[grow] : styles.growSizes['1'])];
  var classes = classNames('euiFlexItem', className);

  // Cast `component` to FunctionComponent to simplify its type.
  // Note that FunctionComponent type is used here for purely typing
  // convenience since we specify the return type above, and function
  // components don't support `ref`s, but that doesn't matter in this case.
  var Component = component;
  return ___EmotionJSX(Component, _extends({}, rest, {
    ref: ref,
    css: cssStyles,
    className: classes
  }), children);
};

// Cast forwardRef return type to work with the generic TComponent type
// and not fallback to implicit any typing
export var EuiFlexItem = /*#__PURE__*/forwardRef(EuiFlexItemInternal);
EuiFlexItem.displayName = 'EuiFlexItem';