import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "onClick", "onClose", "closeButtonPosition", "side"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useEuiI18n } from '../i18n';
import { EuiButtonIcon } from '../button';
import { euiFlyoutCloseButtonStyles } from './_flyout_close_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFlyoutCloseButton = function EuiFlyoutCloseButton(_ref) {
  var className = _ref.className,
    _onClick = _ref.onClick,
    onClose = _ref.onClose,
    closeButtonPosition = _ref.closeButtonPosition,
    side = _ref.side,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiFlyout__closeButton', className);
  var styles = useEuiMemoizedStyles(euiFlyoutCloseButtonStyles);
  var cssStyles = [styles.euiFlyout__closeButton, styles[closeButtonPosition], closeButtonPosition === 'outside' && styles.outsideSide[side]];
  var ariaLabel = useEuiI18n('euiFlyoutCloseButton.ariaLabel', 'Close this dialog');
  return ___EmotionJSX(EuiButtonIcon, _extends({
    display: closeButtonPosition === 'outside' ? 'fill' : 'empty',
    iconType: "cross",
    color: "text",
    "aria-label": ariaLabel,
    "data-test-subj": "euiFlyoutCloseButton"
  }, rest, {
    className: classes,
    css: cssStyles,
    onClick: function onClick(e) {
      onClose(e.nativeEvent);
      _onClick === null || _onClick === void 0 || _onClick(e);
    }
  }));
};