import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiFlyout } from './flyout';
import { EuiButtonEmpty } from '../button';
import { jsx as ___EmotionJSX } from "@emotion/react";
var childrenDefault = ___EmotionJSX(React.Fragment, null, ___EmotionJSX("button", {
  "data-test-subj": "itemA"
}, "Item A"), ___EmotionJSX("button", {
  "data-test-subj": "itemB"
}, "Item B"), ___EmotionJSX("button", {
  "data-test-subj": "itemC"
}, "Item C"), ___EmotionJSX("input", {
  "data-test-subj": "itemD"
}));
var Flyout = function Flyout(_ref) {
  var _ref$children = _ref.children,
    children = _ref$children === void 0 ? childrenDefault : _ref$children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var onButtonClick = function onButtonClick() {
    return setIsOpen(!isOpen);
  };
  var button = ___EmotionJSX(EuiButtonEmpty, {
    onClick: onButtonClick
  }, "Toggle flyout");
  return ___EmotionJSX("div", null, button, isOpen ? ___EmotionJSX(EuiFlyout, _extends({
    "data-test-subj": "flyoutSpec",
    onClose: function onClose() {
      return setIsOpen(false);
    }
  }, rest), children) : null);
};
beforeEach(function () {
  cy.mount(___EmotionJSX(Flyout, null));
  cy.get('div.euiFlyout').should('not.exist');
});
describe('EuiFlyout', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when flyout is opened', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiFlyout').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when flyout is closed', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiFlyout').should('exist');
      cy.get('button.euiFlyout__closeButton').click();
      cy.get('div.euiFlyout').should('not.exist');
      cy.checkAxe();
    });
  });
});