import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "banner", "scrollableTabIndex"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { euiFlyoutBodyStyles } from './flyout_body.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFlyoutBody = function EuiFlyoutBody(_ref) {
  var children = _ref.children,
    className = _ref.className,
    banner = _ref.banner,
    _ref$scrollableTabInd = _ref.scrollableTabIndex,
    scrollableTabIndex = _ref$scrollableTabInd === void 0 ? 0 : _ref$scrollableTabInd,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiFlyoutBody', className);
  var styles = useEuiMemoizedStyles(euiFlyoutBodyStyles);
  var overflowCssStyles = [styles.overflow.euiFlyoutBody__overflow, banner ? styles.overflow.hasBanner : styles.overflow.noBanner];
  return ___EmotionJSX("div", _extends({
    className: classes,
    css: styles.euiFlyoutBody
  }, rest), ___EmotionJSX("div", {
    tabIndex: scrollableTabIndex,
    className: "euiFlyoutBody__overflow",
    css: overflowCssStyles
  }, banner && ___EmotionJSX("div", {
    className: "euiFlyoutBody__banner",
    css: styles.euiFlyoutBody__banner
  }, banner), ___EmotionJSX("div", {
    className: "euiFlyoutBody__overflowContent"
  }, children)));
};