/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalCSSWithFallback, euiYScrollWithShadows } from '../../global_styling';
export var euiFlyoutBodyStyles = function euiFlyoutBodyStyles(euiThemeContext) {
  return {
    euiFlyoutBody: /*#__PURE__*/css(logicalCSSWithFallback('overflow-y', 'hidden'), " ", logicalCSS('height', '100%'), ";;label:euiFlyoutBody;"),
    overflow: {
      euiFlyoutBody__overflow: /*#__PURE__*/css(";label:euiFlyoutBody__overflow;"),
      noBanner: /*#__PURE__*/css(euiYScrollWithShadows(euiThemeContext), ";;label:noBanner;"),
      hasBanner: /*#__PURE__*/css(euiYScrollWithShadows(euiThemeContext, {
        side: 'end'
      }), ";;label:hasBanner;")
    },
    euiFlyoutBody__banner: /*#__PURE__*/css(logicalCSSWithFallback('overflow-x', 'hidden'), ";;label:euiFlyoutBody__banner;")
  };
};