import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["size", "maxWidth", "minWidth", "onResize", "side", "type", "ownFocus", "children"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, useState, useEffect, useRef, useMemo, useCallback } from 'react';
import { keys, useCombinedRefs, useEuiMemoizedStyles } from '../../services';
import { EuiResizableButton } from '../resizable_container';
import { getPosition } from '../resizable_container/helpers';
import { EuiFlyout } from './flyout';
import { euiFlyoutResizableButtonStyles } from './flyout_resizable.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
// If not omitted, the correct props don't show up in the docs prop table

export var EuiFlyoutResizable = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var size = _ref.size,
    maxWidth = _ref.maxWidth,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 200 : _ref$minWidth,
    onResize = _ref.onResize,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'right' : _ref$side,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'overlay' : _ref$type,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? true : _ref$ownFocus,
    children = _ref.children,
    rest = _objectWithoutProperties(_ref, _excluded);
  var hasOverlay = type === 'overlay' && ownFocus;
  var styles = useEuiMemoizedStyles(euiFlyoutResizableButtonStyles);
  var cssStyles = [styles.euiFlyoutResizableButton, styles[type][side], !hasOverlay && styles.noOverlay.noOverlay, !hasOverlay && styles.noOverlay[side]];
  var getFlyoutMinMaxWidth = useCallback(function (width) {
    return Math.min(Math.max(width, minWidth), maxWidth || Infinity, window.innerWidth - 20 // Leave some offset
    );
  }, [minWidth, maxWidth]);
  var _useState = useState(0),
    _useState2 = _slicedToArray(_useState, 2),
    flyoutWidth = _useState2[0],
    setFlyoutWidth = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    callOnResize = _useState4[0],
    setCallOnResize = _useState4[1];

  // Must use state for the flyout ref in order for the useEffect to be correctly called after render
  var _useState5 = useState(null),
    _useState6 = _slicedToArray(_useState5, 2),
    flyoutRef = _useState6[0],
    setFlyoutRef = _useState6[1];
  var setRefs = useCombinedRefs([setFlyoutRef, ref]);
  useEffect(function () {
    if (!flyoutWidth && flyoutRef) {
      setCallOnResize(false); // Don't call `onResize` for non-user width changes
      setFlyoutWidth(getFlyoutMinMaxWidth(flyoutRef.offsetWidth));
    }
  }, [flyoutWidth, flyoutRef, getFlyoutMinMaxWidth]);

  // Update flyout width when consumers pass in a new `size`
  useEffect(function () {
    setCallOnResize(false);
    // For string `size`s, resetting flyoutWidth to 0 will trigger the above useEffect's recalculation
    setFlyoutWidth(typeof size === 'number' ? getFlyoutMinMaxWidth(size) : 0);
  }, [size, getFlyoutMinMaxWidth]);

  // Initial numbers to calculate from, on resize drag start
  var initialWidth = useRef(0);
  var initialMouseX = useRef(0);

  // Account for flyout side and logical property direction
  var direction = useMemo(function () {
    var modifier = side === 'right' ? -1 : 1;
    if (flyoutRef) {
      var languageDirection = window.getComputedStyle(flyoutRef).direction;
      if (languageDirection === 'rtl') modifier *= -1;
    }
    return modifier;
  }, [side, flyoutRef]);
  var onMouseMove = useCallback(function (e) {
    var mouseOffset = getPosition(e, true) - initialMouseX.current;
    var changedFlyoutWidth = initialWidth.current + mouseOffset * direction;
    setFlyoutWidth(getFlyoutMinMaxWidth(changedFlyoutWidth));
  }, [getFlyoutMinMaxWidth, direction]);
  var onMouseUp = useCallback(function () {
    setCallOnResize(true);
    initialMouseX.current = 0;
    window.removeEventListener('mousemove', onMouseMove);
    window.removeEventListener('mouseup', onMouseUp);
    window.removeEventListener('touchmove', onMouseMove);
    window.removeEventListener('touchend', onMouseUp);
  }, [onMouseMove]);
  var onMouseDown = useCallback(function (e) {
    var _flyoutRef$offsetWidt;
    setCallOnResize(false);
    initialMouseX.current = getPosition(e, true);
    initialWidth.current = (_flyoutRef$offsetWidt = flyoutRef === null || flyoutRef === void 0 ? void 0 : flyoutRef.offsetWidth) !== null && _flyoutRef$offsetWidt !== void 0 ? _flyoutRef$offsetWidt : 0;

    // Window event listeners instead of React events are used
    // in case the user's mouse leaves the component
    window.addEventListener('mousemove', onMouseMove);
    window.addEventListener('mouseup', onMouseUp);
    window.addEventListener('touchmove', onMouseMove);
    window.addEventListener('touchend', onMouseUp);
  }, [flyoutRef, onMouseMove, onMouseUp]);
  var onKeyDown = useCallback(function (e) {
    setCallOnResize(true);
    var KEYBOARD_OFFSET = 10;
    switch (e.key) {
      case keys.ARROW_RIGHT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth + KEYBOARD_OFFSET * direction);
        });
        break;
      case keys.ARROW_LEFT:
        e.preventDefault(); // Safari+VO will screen reader navigate off the button otherwise
        setFlyoutWidth(function (flyoutWidth) {
          return getFlyoutMinMaxWidth(flyoutWidth - KEYBOARD_OFFSET * direction);
        });
    }
  }, [getFlyoutMinMaxWidth, direction]);

  // To reduce unnecessary calls, only fire onResize callback:
  // 1. After initial mount / on user width change events only
  // 2. If not currently mouse dragging
  useEffect(function () {
    if (callOnResize) {
      onResize === null || onResize === void 0 || onResize(flyoutWidth);
    }
  }, [onResize, callOnResize, flyoutWidth]);
  return ___EmotionJSX(EuiFlyout, _extends({}, rest, {
    size: flyoutWidth || size,
    maxWidth: maxWidth,
    side: side,
    type: type,
    ownFocus: ownFocus,
    ref: setRefs
  }), ___EmotionJSX(EuiResizableButton, {
    isHorizontal: true,
    indicator: "border",
    css: cssStyles,
    onMouseDown: onMouseDown,
    onTouchStart: onMouseDown,
    onKeyDown: onKeyDown
  }), children);
});
EuiFlyoutResizable.displayName = 'EuiFlyoutResizable';