import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiBadge } from '../badge';
import { EuiButton } from '../button';
import { EuiCheckboxGroup, EuiFieldText } from '../form';
import { EuiFocusTrap } from './focus_trap';
import { EuiSpacer } from '../spacer';
import { EuiPanel } from '../panel';
import { EuiText } from '../text';
import { useGeneratedHtmlId } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
var CheckboxGroup = function CheckboxGroup() {
  var checkboxGroupItemId__1 = useGeneratedHtmlId({
    prefix: 'checkboxGroupItem',
    suffix: 'first'
  });
  var checkboxGroupItemId__2 = useGeneratedHtmlId({
    prefix: 'checkboxGroupItem',
    suffix: 'second'
  });
  var checkboxes = [{
    id: checkboxGroupItemId__1,
    label: 'Option one is checked by default'
  }, {
    id: checkboxGroupItemId__2,
    label: 'Option two'
  }];
  var _useState = useState(_defineProperty({}, checkboxGroupItemId__1, true)),
    _useState2 = _slicedToArray(_useState, 1),
    checkboxIdToSelectedMap = _useState2[0];
  return ___EmotionJSX(EuiCheckboxGroup, {
    options: checkboxes,
    idToSelectedMap: checkboxIdToSelectedMap,
    onChange: function onChange() {}
  });
};
var FocusTrap = function FocusTrap() {
  var _useState4 = useState(true),
    _useState5 = _slicedToArray(_useState4, 2),
    isDisabled = _useState5[0],
    changeDisabled = _useState5[1];
  var toggleDisabled = function toggleDisabled() {
    return changeDisabled(!isDisabled);
  };
  return ___EmotionJSX("div", {
    "data-test-subj": "cy-trap-container"
  }, ___EmotionJSX(EuiBadge, {
    "data-test-subj": "cy-trap-message"
  }, "Trap is ", isDisabled ? 'disabled' : 'enabled'), ___EmotionJSX(EuiSpacer, {
    size: "s"
  }), ___EmotionJSX(EuiFocusTrap, {
    disabled: isDisabled
  }, ___EmotionJSX(EuiPanel, null, ___EmotionJSX(EuiFieldText, {
    "data-test-subj": "cy-input-one",
    placeholder: "Placeholder text first input",
    value: "",
    onChange: function onChange() {},
    "aria-label": "First focusable input"
  }), ___EmotionJSX(EuiSpacer, {
    size: "m"
  }), ___EmotionJSX(CheckboxGroup, null), ___EmotionJSX(EuiSpacer, {
    size: "m"
  }), ___EmotionJSX(EuiButton, {
    onClick: toggleDisabled,
    "data-test-subj": "cy-focus-trap-button"
  }, "".concat(!isDisabled ? 'Disable' : 'Enable', " Focus Trap")))), ___EmotionJSX(EuiSpacer, {
    size: "l"
  }), ___EmotionJSX(EuiText, null, "The button below is not focusable by keyboard as long as the focus trap is enabled."), ___EmotionJSX(EuiButton, {
    onClick: function onClick() {},
    "data-test-subj": "cy-external-button"
  }, "External Focusable Element"));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount(___EmotionJSX(FocusTrap, null));
});
describe('EuiFocusTrap', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the focus trap is enabled', function () {
      cy.get('button[data-test-subj="cy-focus-trap-button"]').realClick();
      cy.get('span[ data-test-subj="cy-trap-message"]').should('have.text', 'Trap is enabled');
      cy.checkAxe();
    });
  });
  describe('Accessibility checks for keyboard navigation', function () {
    it('allows the button outside the FocusTrap to receive focus', function () {
      cy.get('button[data-test-subj="cy-external-button"]').focus();
      cy.checkAxe();
    });
    it('prevents the button outside the FocusTrap from receiving focus', function () {
      cy.get('input[data-test-subj="cy-input-one"]').focus();
      cy.repeatRealPress('Tab', 3);
      cy.realPress('Enter');
      cy.realPress('Tab');
      cy.get('input[data-test-subj="cy-input-one"]').should('have.focus');
      cy.checkAxe();
    });
  });
});