import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "clickOutsideDisables", "disabled", "returnFocus", "noIsolation", "scrollLock", "gapMode"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import { FocusOn } from 'react-focus-on';
import { RemoveScrollBar } from 'react-remove-scroll-bar';
import { findElementBySelectorOrRef } from '../../services';
import { usePropsWithComponentDefaults } from '../provider/component_defaults';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFocusTrap = function EuiFocusTrap(props) {
  var propsWithDefaults = usePropsWithComponentDefaults('EuiFocusTrap', props);
  return ___EmotionJSX(EuiFocusTrapClass, propsWithDefaults);
};
var EuiFocusTrapClass = /*#__PURE__*/function (_Component) {
  function EuiFocusTrapClass() {
    var _this;
    _classCallCheck(this, EuiFocusTrapClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFocusTrapClass, [].concat(args));
    _defineProperty(_this, "state", {
      hasBeenDisabledByClick: false
    });
    _defineProperty(_this, "lastInterceptedEvent", null);
    _defineProperty(_this, "preventFocusExit", false);
    // Programmatically sets focus on a nested DOM node; optional
    _defineProperty(_this, "setInitialFocus", function (initialFocus) {
      if (!initialFocus) return;
      var node = findElementBySelectorOrRef(initialFocus);
      if (!node) return;
      // `data-autofocus` is part of the 'react-focus-on' API
      node.setAttribute('data-autofocus', 'true');
    });
    _defineProperty(_this, "onMouseupOutside", function (e) {
      _this.removeMouseupListener();
      // Timeout gives precedence to the consumer to initiate close if it has toggle behavior.
      // Otherwise this event may occur first and the consumer toggle will reopen the flyout.
      setTimeout(function () {
        var _this$props$onClickOu, _this$props;
        return (_this$props$onClickOu = (_this$props = _this.props).onClickOutside) === null || _this$props$onClickOu === void 0 ? void 0 : _this$props$onClickOu.call(_this$props, e);
      });
    });
    _defineProperty(_this, "addMouseupListener", function () {
      document.addEventListener('mouseup', _this.onMouseupOutside);
      document.addEventListener('touchend', _this.onMouseupOutside);
    });
    _defineProperty(_this, "removeMouseupListener", function () {
      document.removeEventListener('mouseup', _this.onMouseupOutside);
      document.removeEventListener('touchend', _this.onMouseupOutside);
    });
    _defineProperty(_this, "handleOutsideClick", function (event) {
      var _this$props2 = _this.props,
        onClickOutside = _this$props2.onClickOutside,
        clickOutsideDisables = _this$props2.clickOutsideDisables,
        closeOnMouseup = _this$props2.closeOnMouseup;
      if (clickOutsideDisables) {
        _this.setState({
          hasBeenDisabledByClick: true
        });
      }
      if (onClickOutside) {
        closeOnMouseup ? _this.addMouseupListener() : onClickOutside(event);
      }
    });
    return _this;
  }
  _inherits(EuiFocusTrapClass, _Component);
  return _createClass(EuiFocusTrapClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setInitialFocus(this.props.initialFocus);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.disabled === true && this.props.disabled === false) {
        this.setState({
          hasBeenDisabledByClick: false
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.removeMouseupListener();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
        children = _this$props3.children,
        clickOutsideDisables = _this$props3.clickOutsideDisables,
        disabled = _this$props3.disabled,
        returnFocus = _this$props3.returnFocus,
        noIsolation = _this$props3.noIsolation,
        scrollLock = _this$props3.scrollLock,
        gapMode = _this$props3.gapMode,
        rest = _objectWithoutProperties(_this$props3, _excluded);
      var isDisabled = disabled || this.state.hasBeenDisabledByClick;
      var focusOnProps = _objectSpread(_objectSpread({
        returnFocus: returnFocus,
        noIsolation: noIsolation,
        enabled: !isDisabled
      }, rest), {}, {
        onClickOutside: this.handleOutsideClick,
        /**
         * `scrollLock` should always be unset on FocusOn, as it can prevent scrolling on
         * portals (i.e. popovers, comboboxes, dropdown menus, etc.) within modals & flyouts
         * @see https://github.com/theKashey/react-focus-on/issues/49
         */
        scrollLock: false
      });
      return ___EmotionJSX(FocusOn, focusOnProps, children, !isDisabled && scrollLock && ___EmotionJSX(RemoveScrollBar, {
        gapMode: gapMode
      }));
    }
  }]);
}(Component);
_defineProperty(EuiFocusTrapClass, "defaultProps", {
  clickOutsideDisables: false,
  disabled: false,
  returnFocus: true,
  noIsolation: true,
  scrollLock: false,
  crossFrame: false,
  gapMode: 'padding' // EUI defaults to padding because Kibana's body/layout CSS ignores `margin`
});