function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFormCustomControlStyles, euiFormCustomControlVariables } from '../form.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1m8ob9b-readOnly",
  styles: "cursor:default;label:readOnly;"
} : {
  name: "1m8ob9b-readOnly",
  styles: "cursor:default;label:readOnly;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "u54glv-indeterminate",
  styles: "transform:scale(0.5);label:indeterminate;"
} : {
  name: "u54glv-indeterminate",
  styles: "transform:scale(0.5);label:indeterminate;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiCheckboxStyles = function euiCheckboxStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var controlStyles = euiFormCustomControlStyles(euiThemeContext);
  var _euiFormCustomControl = euiFormCustomControlVariables(euiThemeContext),
    unselectedBorder = _euiFormCustomControl.colors.unselectedBorder;
  return {
    euiCheckbox: /*#__PURE__*/css(controlStyles.wrapper, ";label:euiCheckbox;"),
    input: {
      euiCheckbox__square: /*#__PURE__*/css(controlStyles.input.fauxInput, " border-radius:", euiTheme.border.radius.small, ";;label:euiCheckbox__square;"),
      hasLabel: controlStyles.input.hasLabel,
      // Skip css`` className generation
      enabled: {
        selected: /*#__PURE__*/css(controlStyles.input.enabled.selected, ";label:selected;"),
        unselected: /*#__PURE__*/css(controlStyles.input.enabled.unselected, ";label:unselected;")
      },
      disabled: {
        selected: /*#__PURE__*/css(controlStyles.input.disabled.selected, ";label:selected;"),
        unselected: /*#__PURE__*/css(controlStyles.input.disabled.unselected, ";label:unselected;")
      },
      // Readonly checkboxes are used by EuiMarkdownEditor
      // Maintain the initial color to enforce that clicks are not doing anything
      readOnly: /*#__PURE__*/css("&:has(input:focus-visible){outline:", euiTheme.focus.width, " solid ", unselectedBorder, ";}&:has(input:focus){border-color:", unselectedBorder, ";};label:readOnly;"),
      icon: {
        euiCheckbox__icon: /*#__PURE__*/css(";label:euiCheckbox__icon;"),
        check: /*#__PURE__*/css(controlStyles.input.icon, " stroke:currentColor;;label:check;"),
        indeterminate: _ref2
      },
      euiCheckbox__input: /*#__PURE__*/css(controlStyles.input.hiddenInput, " &[readonly]{cursor:default;};label:euiCheckbox__input;")
    },
    label: {
      euiCheckbox__label: /*#__PURE__*/css(controlStyles.label.label, ";label:euiCheckbox__label;"),
      enabled: controlStyles.label.enabled,
      disabled: /*#__PURE__*/css(controlStyles.label.disabled, ";label:disabled;"),
      readOnly: _ref
    }
  };
};