import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />

import React, { useState } from 'react';
import { EuiCheckboxGroup } from './checkbox_group';
import { jsx as ___EmotionJSX } from "@emotion/react";
var CheckBoxGroup = function CheckBoxGroup() {
  var checkboxGroupItemId__1 = 'cy-group-id-1';
  var checkboxGroupItemId__2 = 'cy-group-id-2';
  var checkboxGroupItemId__3 = 'cy-group-id-3';
  var checkboxGroupItemId__4 = 'cy-group-id-4';
  var checkboxes = [{
    id: checkboxGroupItemId__1,
    label: 'Option one',
    'data-test-subj': 'cy-checkbox-1'
  }, {
    id: checkboxGroupItemId__2,
    label: 'Option two is checked by default',
    className: 'classNameTest',
    'data-test-subj': 'cy-checkbox-2'
  }, {
    id: checkboxGroupItemId__3,
    label: 'Option three is disabled',
    'data-test-subj': 'cy-checkbox-3',
    disabled: true
  }, {
    id: checkboxGroupItemId__4,
    label: 'Option four',
    'data-test-subj': 'cy-checkbox-4'
  }];
  var _useState = useState(_defineProperty({}, checkboxGroupItemId__2, true)),
    _useState2 = _slicedToArray(_useState, 2),
    checkboxIdToSelectedMap = _useState2[0],
    setCheckboxIdToSelectedMap = _useState2[1];
  var _onChange = function onChange(optionId) {
    var newCheckboxIdToSelectedMap = _objectSpread(_objectSpread({}, checkboxIdToSelectedMap), _defineProperty({}, optionId, !checkboxIdToSelectedMap[optionId]));
    setCheckboxIdToSelectedMap(newCheckboxIdToSelectedMap);
  };
  return ___EmotionJSX(EuiCheckboxGroup, {
    options: checkboxes,
    idToSelectedMap: checkboxIdToSelectedMap,
    onChange: function onChange(id) {
      return _onChange(id);
    }
  });
};
describe('EuiCheckBoxGroup', function () {
  beforeEach(function () {
    cy.realMount(___EmotionJSX(CheckBoxGroup, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations when rendered', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility', function () {
    it('has zero violations after traversing checkboxes', function () {
      cy.realPress('Tab');
      cy.get('[data-test-subj="cy-checkbox-1"]').should('have.focus');
      cy.realPress('Space');
      cy.get('[data-test-subj="cy-checkbox-1"]').should('be.checked');
      cy.realPress('Tab');
      cy.get('[data-test-subj="cy-checkbox-2"]').should('have.focus');
      cy.realPress('Space');
      cy.get('[data-test-subj="cy-checkbox-2"]').should('not.be.checked');
      cy.realPress('Tab');
      cy.get('[data-test-subj="cy-checkbox-4"]').should('have.focus');
      cy.checkAxe();
    });
  });
  describe('Disabled checkbox accessibility', function () {
    it('affects no change after clicking the disabled checkbox', function () {
      cy.get('[data-test-subj="cy-checkbox-3"]').realClick();
      cy.get('[data-test-subj="cy-checkbox-3"]').should('not.be.checked');
      cy.checkAxe();
    });
  });
});