import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["options", "idToSelectedMap", "onChange", "className", "disabled", "compressed", "legend"],
  _excluded2 = ["disabled", "className"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiFormFieldset } from '../form_fieldset';
import { EuiCheckbox } from './checkbox';
import { euiCheckboxGroupStyles } from './checkbox_group.styles';

// Must omit inherit `onChange` properties or else TS complains when applying to the EuiRadio
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiCheckboxGroup = function EuiCheckboxGroup(_ref) {
  var _ref$options = _ref.options,
    options = _ref$options === void 0 ? [] : _ref$options,
    _ref$idToSelectedMap = _ref.idToSelectedMap,
    idToSelectedMap = _ref$idToSelectedMap === void 0 ? {} : _ref$idToSelectedMap,
    onChange = _ref.onChange,
    className = _ref.className,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    legend = _ref.legend,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiCheckboxGroup', className);
  var styles = useEuiMemoizedStyles(euiCheckboxGroupStyles);
  var cssStyles = [styles.euiCheckboxGroup, compressed ? styles.compressed : styles.uncompressed];
  var checkboxes = options.map(function (option, index) {
    var isOptionDisabled = option.disabled,
      optionClass = option.className,
      optionRest = _objectWithoutProperties(option, _excluded2);
    return ___EmotionJSX(EuiCheckbox, _extends({
      className: classNames('euiCheckboxGroup__item', optionClass),
      key: index,
      checked: idToSelectedMap[option.id],
      disabled: disabled || isOptionDisabled,
      onChange: onChange.bind(null, option.id)
    }, optionRest));
  });
  if (!!legend) {
    // Be sure to pass down the compressed option to the legend
    legend.compressed = compressed;
    return ___EmotionJSX(EuiFormFieldset, _extends({
      css: cssStyles,
      className: classes,
      legend: legend
    }, rest), checkboxes);
  }
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), checkboxes);
};