import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "gutterSize", "fullWidth", "ratio", "titleSize", "title", "description", "descriptionFlexItemProps", "fieldFlexItemProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiTitle } from '../../title';
import { EuiText } from '../../text';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { useFormContext } from '../eui_form_context';
import { euiDescribedFormGroupStyles } from './described_form_group.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiDescribedFormGroup = function EuiDescribedFormGroup(props) {
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var children = props.children,
    className = props.className,
    _props$gutterSize = props.gutterSize,
    gutterSize = _props$gutterSize === void 0 ? 'l' : _props$gutterSize,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$ratio = props.ratio,
    ratio = _props$ratio === void 0 ? 'half' : _props$ratio,
    _props$titleSize = props.titleSize,
    titleSize = _props$titleSize === void 0 ? 'xs' : _props$titleSize,
    title = props.title,
    description = props.description,
    descriptionFlexItemProps = props.descriptionFlexItemProps,
    fieldFlexItemProps = props.fieldFlexItemProps,
    rest = _objectWithoutProperties(props, _excluded);
  var styles = useEuiMemoizedStyles(euiDescribedFormGroupStyles);
  var cssStyles = [styles.euiDescribedFormGroup, fullWidth ? styles.fullWidth : styles.formWidth];
  var descriptionColumnStyles = [styles.euiDescribedFormGroup__descriptionColumn, descriptionFlexItemProps === null || descriptionFlexItemProps === void 0 ? void 0 : descriptionFlexItemProps.css];
  var fieldColumnStyles = [styles.euiDescribedFormGroup__fields, fieldFlexItemProps === null || fieldFlexItemProps === void 0 ? void 0 : fieldFlexItemProps.css];
  var classes = classNames('euiDescribedFormGroup', className);
  var fieldClasses = classNames('euiDescribedFormGroup__fields', fieldFlexItemProps && fieldFlexItemProps.className);
  var renderedDescription;
  if (description) {
    renderedDescription = ___EmotionJSX(EuiText, {
      size: "s",
      color: "subdued",
      css: styles.euiDescribedFormGroup__description,
      className: "euiDescribedFormGroup__description"
    },
    // If the description is just a string, wrap it in a paragraph element
    typeof description === 'string' ? ___EmotionJSX("p", null, description) : description);
  }
  var fieldGrowth;
  switch (ratio) {
    case 'half':
      fieldGrowth = 1;
      break;
    case 'third':
      fieldGrowth = 2;
      break;
    case 'quarter':
      fieldGrowth = 3;
      break;
    default:
      console.warn('Please provide an allowed ratio to EuiDescribedFromRow');
      break;
  }
  return ___EmotionJSX(EuiFlexGroup, _extends({
    role: "group"
  }, rest, {
    css: cssStyles,
    className: classes,
    alignItems: "baseline",
    gutterSize: gutterSize
  }), ___EmotionJSX(EuiFlexItem, _extends({
    grow: 1
  }, descriptionFlexItemProps, {
    css: descriptionColumnStyles,
    className: classNames('euiDescribedFormGroup__descriptionColumn', descriptionFlexItemProps === null || descriptionFlexItemProps === void 0 ? void 0 : descriptionFlexItemProps.className)
  }), ___EmotionJSX(EuiTitle, {
    size: titleSize,
    className: "euiDescribedFormGroup__title"
  }, title), renderedDescription), ___EmotionJSX(EuiFlexItem, _extends({
    grow: fieldGrowth
  }, fieldFlexItemProps, {
    css: fieldColumnStyles,
    className: fieldClasses
  }), children));
};