/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits } from '../../../global_styling';
import { euiFormMaxWidth } from '../form.styles';
export var euiDescribedFormGroupStyles = function euiDescribedFormGroupStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formMaxWidth = euiFormMaxWidth(euiThemeContext);
  return {
    euiDescribedFormGroup: /*#__PURE__*/css("&+*{", logicalCSS('margin-top', euiTheme.size.l), ";};label:euiDescribedFormGroup;"),
    // Skip css`` to avoid generating an Emotion className
    formWidth: "\n      ".concat(logicalCSS('max-width', mathWithUnits(formMaxWidth, function (x) {
      return x * 2;
    })), "\n    "),
    fullWidth: /*#__PURE__*/css(logicalCSS('max-width', '100%'), ";;label:fullWidth;"),
    euiDescribedFormGroup__descriptionColumn: /*#__PURE__*/css(logicalCSS('min-width', 'min(20rem, 50%)'), ";;label:euiDescribedFormGroup__descriptionColumn;"),
    euiDescribedFormGroup__description: /*#__PURE__*/css(logicalCSS('padding-top', euiTheme.size.s), ";;label:euiDescribedFormGroup__description;"),
    euiDescribedFormGroup__fields: /*#__PURE__*/css(logicalCSS('min-width', 0), "&>.euiFormRow:first-child:not(.euiFormRow--hasLabel){&::before{content:'';}}&>.euiFormRow--hasEmptyLabelSpace:first-child{", logicalCSS('margin-top', 0), ";};label:euiDescribedFormGroup__fields;")
  };
};