import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "icon", "id", "placeholder", "name", "min", "max", "step", "value", "isInvalid", "fullWidth", "isLoading", "compressed", "prepend", "append", "inputRef", "readOnly", "controlOnly", "onKeyUp"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useEffect, useCallback, useRef } from 'react';
import classNames from 'classnames';
import { useCombinedRefs, useEuiMemoizedStyles } from '../../../services';
import { EuiValidatableControl } from '../validatable_control';
import { EuiFormControlLayout } from '../form_control_layout';
import { useFormContext } from '../eui_form_context';
import { euiFieldNumberStyles } from './field_number.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFieldNumber = function EuiFieldNumber(props) {
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var className = props.className,
    icon = props.icon,
    id = props.id,
    placeholder = props.placeholder,
    name = props.name,
    min = props.min,
    max = props.max,
    _props$step = props.step,
    step = _props$step === void 0 ? 'any' : _props$step,
    value = props.value,
    isInvalid = props.isInvalid,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$isLoading = props.isLoading,
    isLoading = _props$isLoading === void 0 ? false : _props$isLoading,
    _props$compressed = props.compressed,
    compressed = _props$compressed === void 0 ? false : _props$compressed,
    prepend = props.prepend,
    append = props.append,
    inputRef = props.inputRef,
    readOnly = props.readOnly,
    controlOnly = props.controlOnly,
    _onKeyUp = props.onKeyUp,
    rest = _objectWithoutProperties(props, _excluded);
  var _inputRef = useRef(null);
  var combinedRefs = useCombinedRefs([_inputRef, inputRef]);

  // Attempt to determine additional invalid state. The native number input
  // will set :invalid state automatically, but we need to also set
  // `aria-invalid` as well as display an icon. We also want to *not* set this on
  // EuiValidatableControl, in order to not override custom validity messages
  var _useState = useState(),
    _useState2 = _slicedToArray(_useState, 2),
    isNativelyInvalid = _useState2[0],
    setIsNativelyInvalid = _useState2[1];
  var checkNativeValidity = useCallback(function (inputEl) {
    // Prefer `undefined` over `false` so that the `aria-invalid` prop unsets completely
    var isInvalid = !inputEl.validity.valid || undefined;
    setIsNativelyInvalid(isInvalid);
  }, []);

  // Re-check validity whenever props that might affect validity are updated
  useEffect(function () {
    if (_inputRef.current) {
      checkNativeValidity(_inputRef.current);
    }
  }, [value, min, max, step, checkNativeValidity]);
  var classes = classNames('euiFieldNumber', className, {
    'euiFieldNumber-isLoading': isLoading
  });
  var styles = useEuiMemoizedStyles(euiFieldNumberStyles);
  var cssStyles = [styles.euiFieldNumber, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, !controlOnly && (prepend || append) && styles.inGroup, controlOnly && styles.controlOnly];
  var control = ___EmotionJSX(EuiValidatableControl, {
    isInvalid: isInvalid
  }, ___EmotionJSX("input", _extends({
    type: "number",
    id: id,
    name: name,
    min: min,
    max: max,
    step: step,
    value: value,
    placeholder: placeholder,
    readOnly: readOnly,
    className: classes,
    css: cssStyles,
    ref: combinedRefs,
    "aria-invalid": isInvalid || isNativelyInvalid,
    onKeyUp: function onKeyUp(e) {
      // Note that we can't use `onChange` because browsers don't emit change events
      // for invalid text - see https://github.com/facebook/react/issues/16554
      _onKeyUp === null || _onKeyUp === void 0 || _onKeyUp(e);
      checkNativeValidity(e.currentTarget);
    }
  }, rest)));
  if (controlOnly) {
    return control;
  }
  return ___EmotionJSX(EuiFormControlLayout, {
    icon: icon,
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid || isNativelyInvalid,
    isDisabled: rest.disabled,
    compressed: compressed,
    readOnly: readOnly,
    prepend: prepend,
    append: append,
    inputId: id
  }, control);
};