import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "id", "name", "placeholder", "value", "disabled", "isInvalid", "fullWidth", "isLoading", "compressed", "inputRef", "prepend", "append", "type", "dualToggleProps"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState, useMemo, useCallback } from 'react';
import classNames from 'classnames';
import { useCombinedRefs, useEuiMemoizedStyles } from '../../../services';
import { useEuiI18n } from '../../i18n';
import { EuiButtonIcon } from '../../button';
import { EuiFormControlLayout } from '../form_control_layout';
import { EuiValidatableControl } from '../validatable_control';
import { useFormContext } from '../eui_form_context';
import { euiFieldPasswordStyles } from './field_password.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFieldPassword = function EuiFieldPassword(props) {
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var className = props.className,
    id = props.id,
    name = props.name,
    placeholder = props.placeholder,
    value = props.value,
    disabled = props.disabled,
    isInvalid = props.isInvalid,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$isLoading = props.isLoading,
    isLoading = _props$isLoading === void 0 ? false : _props$isLoading,
    _props$compressed = props.compressed,
    compressed = _props$compressed === void 0 ? false : _props$compressed,
    _inputRef = props.inputRef,
    prepend = props.prepend,
    append = props.append,
    _props$type = props.type,
    type = _props$type === void 0 ? 'password' : _props$type,
    dualToggleProps = props.dualToggleProps,
    rest = _objectWithoutProperties(props, _excluded);

  // Set the initial input type to `password` if they want dual
  var _useState = useState(type === 'dual' ? 'password' : type),
    _useState2 = _slicedToArray(_useState, 2),
    inputType = _useState2[0],
    setInputType = _useState2[1];

  // Setup toggle aria-label
  var _useEuiI18n = useEuiI18n(['euiFieldPassword.showPassword', 'euiFieldPassword.maskPassword'], ['Show password as plain text. Note: this will visually expose your password on the screen.', 'Mask password']),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
    showPasswordLabel = _useEuiI18n2[0],
    maskPasswordLabel = _useEuiI18n2[1];

  // Setup the inputRef to auto-focus when toggling visibility
  var _useState3 = useState(null),
    _useState4 = _slicedToArray(_useState3, 2),
    inputRef = _useState4[0],
    _setInputRef = _useState4[1];
  var setInputRef = useCombinedRefs([_setInputRef, _inputRef]);
  var handleToggle = useCallback(function (event, isVisible) {
    var _dualToggleProps$onCl;
    setInputType(isVisible ? 'password' : 'text');
    inputRef === null || inputRef === void 0 || inputRef.focus();
    dualToggleProps === null || dualToggleProps === void 0 || (_dualToggleProps$onCl = dualToggleProps.onClick) === null || _dualToggleProps$onCl === void 0 || _dualToggleProps$onCl.call(dualToggleProps, event);
  }, [inputRef, dualToggleProps]);

  // Add a toggling button to switch between `password` and `input` if consumer wants `dual`
  // https://www.w3schools.com/howto/howto_js_toggle_password.asp
  var visibilityToggle = useMemo(function () {
    if (type === 'dual') {
      var isVisible = inputType === 'text';
      return ___EmotionJSX(EuiButtonIcon, _extends({
        iconType: isVisible ? 'eyeClosed' : 'eye',
        "aria-label": isVisible ? maskPasswordLabel : showPasswordLabel,
        title: isVisible ? maskPasswordLabel : showPasswordLabel,
        disabled: disabled
      }, dualToggleProps, {
        onClick: function onClick(e) {
          return handleToggle(e, isVisible);
        }
      }));
    }
  }, [type, inputType, maskPasswordLabel, showPasswordLabel, dualToggleProps, handleToggle, disabled]);
  var finalAppend = useMemo(function () {
    if (!visibilityToggle) return append;
    if (!append) return visibilityToggle;

    // Convert any `append` elements to an array so the visibility
    // toggle can be added to it
    var appendAsArray = append ? Array.isArray(append) ? append : [append] : [];
    return [].concat(_toConsumableArray(appendAsArray), [visibilityToggle]);
  }, [append, visibilityToggle]);
  var classes = classNames('euiFieldPassword', {
    'euiFieldPassword-isLoading': isLoading
  }, className);
  var styles = useEuiMemoizedStyles(euiFieldPasswordStyles);
  var cssStyles = [styles.euiFieldPassword, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, (finalAppend || prepend) && styles.inGroup, type === 'dual' && styles.withToggle];
  return ___EmotionJSX(EuiFormControlLayout, {
    icon: "lock",
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: disabled,
    compressed: compressed,
    prepend: prepend,
    append: finalAppend
  }, ___EmotionJSX(EuiValidatableControl, {
    isInvalid: isInvalid
  }, ___EmotionJSX("input", _extends({
    type: inputType,
    id: id,
    name: name,
    placeholder: placeholder,
    className: classes,
    css: cssStyles,
    value: value,
    disabled: disabled,
    ref: setInputRef
  }, rest))));
};