import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["stylesMemoizer", "className", "id", "name", "placeholder", "isInvalid", "disabled", "fullWidth", "isLoading", "inputRef", "incremental", "compressed", "onSearch", "isClearable", "append", "prepend"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { keys, withEuiStylesMemoizer } from '../../../services';
import { Browser } from '../../../services/browser';
import { EuiI18n } from '../../i18n';
import { EuiFormControlLayout } from '../form_control_layout';
import { EuiValidatableControl } from '../validatable_control';
import { FormContext } from '../eui_form_context';
import { euiFieldSearchStyles } from './field_search.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var isSearchSupported = false;
export var EuiFieldSearchClass = /*#__PURE__*/function (_Component) {
  function EuiFieldSearchClass() {
    var _this;
    _classCallCheck(this, EuiFieldSearchClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFieldSearchClass, [].concat(args));
    _defineProperty(_this, "state", {
      value: _this.props.value || String(_this.props.defaultValue || '')
    });
    _defineProperty(_this, "inputElement", null);
    _defineProperty(_this, "cleanups", []);
    _defineProperty(_this, "onClear", function () {
      // clear the field's value

      // 1. React doesn't listen for `change` events, instead it maps `input` events to `change`
      // 2. React only fires the mapped `change` event if the element's value has changed
      // 3. An input's value is, in addition to other methods, tracked by intercepting element.value = '...'
      //
      // So we have to go below the element's value setter to avoid React intercepting it,
      // only then will React treat the value as different and fire its `change` event
      //
      // https://stackoverflow.com/questions/23892547/what-is-the-best-way-to-trigger-onchange-event-in-react-js
      var nativeInputValue = Object.getOwnPropertyDescriptor(HTMLInputElement.prototype, 'value');
      var nativeInputValueSetter = nativeInputValue ? nativeInputValue.set : undefined;
      if (nativeInputValueSetter) {
        nativeInputValueSetter.call(_this.inputElement, '');
      }

      // dispatch input event
      var event = new Event('input', {
        bubbles: true,
        cancelable: false
      });
      if (_this.inputElement) {
        _this.inputElement.dispatchEvent(event);
        // set focus on the search field
        _this.inputElement.focus();
        _this.inputElement.dispatchEvent(new Event('change'));
      }
      _this.setState({
        value: ''
      });
      var _this$props = _this.props,
        incremental = _this$props.incremental,
        onSearch = _this$props.onSearch;
      if (onSearch && incremental) {
        onSearch('');
      }
    });
    _defineProperty(_this, "setRef", function (inputElement) {
      _this.inputElement = inputElement;
      if (_this.props.inputRef) {
        _this.props.inputRef(inputElement);
      }
    });
    _defineProperty(_this, "onKeyUp", function (event, incremental, onSearch) {
      _this.setState({
        value: event.target.value
      });
      if (_this.props.onKeyUp) {
        _this.props.onKeyUp(event);
        if (event.defaultPrevented) {
          return;
        }
      }
      if (onSearch && (event.key !== keys.ENTER && incremental || event.key === keys.ENTER && !isSearchSupported)) {
        onSearch(event.target.value);
      }
    });
    return _this;
  }
  _inherits(EuiFieldSearchClass, _Component);
  return _createClass(EuiFieldSearchClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;
      if (!this.inputElement) return;
      isSearchSupported = Browser.isEventSupported('search', this.inputElement);
      if (isSearchSupported) {
        var onSearch = function onSearch(event) {
          if (_this2.props.onSearch) {
            if (!event || !event.target || event.defaultPrevented) return;
            _this2.props.onSearch(event.target.value);
          }
        };
        this.inputElement.addEventListener('search', onSearch);
        this.cleanups.push(function () {
          if (!_this2.inputElement) return;
          _this2.inputElement.removeEventListener('search', onSearch);
        });
      }
      var onChange = function onChange(event) {
        if (event.target && event.target.value !== _this2.state.value) {
          _this2.setState({
            value: event.target.value
          });
          if (_this2.props.onSearch) {
            _this2.props.onSearch(event.target.value);
          }
        }
      };
      this.inputElement.addEventListener('change', onChange);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.cleanups.forEach(function (cleanup) {
        return cleanup();
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var _ref = this.context,
        defaultFullWidth = _ref.defaultFullWidth;
      var _this$props2 = this.props,
        stylesMemoizer = _this$props2.stylesMemoizer,
        className = _this$props2.className,
        id = _this$props2.id,
        name = _this$props2.name,
        placeholder = _this$props2.placeholder,
        isInvalid = _this$props2.isInvalid,
        disabled = _this$props2.disabled,
        _this$props2$fullWidt = _this$props2.fullWidth,
        fullWidth = _this$props2$fullWidt === void 0 ? defaultFullWidth : _this$props2$fullWidt,
        isLoading = _this$props2.isLoading,
        inputRef = _this$props2.inputRef,
        incremental = _this$props2.incremental,
        compressed = _this$props2.compressed,
        onSearch = _this$props2.onSearch,
        _isClearable = _this$props2.isClearable,
        append = _this$props2.append,
        prepend = _this$props2.prepend,
        rest = _objectWithoutProperties(_this$props2, _excluded);
      var value = this.props.value;
      if (typeof this.props.value !== 'string') value = this.state.value;

      // Set actual value of isClearable if value exists as well
      var isClearable = Boolean(_isClearable && value && !rest.readOnly && !disabled);
      var classes = classNames('euiFieldSearch', {
        'euiFieldSearch-isLoading': isLoading,
        'euiFieldSearch-isClearable': isClearable,
        'euiFieldSearch-isInvalid': isInvalid
      }, className);
      var styles = stylesMemoizer(euiFieldSearchStyles);
      var cssStyles = [styles.euiFieldSearch, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, (prepend || append) && styles.inGroup];
      return ___EmotionJSX(EuiI18n, {
        token: "euiFieldSearch.clearSearchButtonLabel",
        default: "Clear search input"
      }, function (clearSearchButtonLabel) {
        return ___EmotionJSX(EuiFormControlLayout, {
          icon: "search",
          fullWidth: fullWidth,
          isLoading: isLoading,
          isInvalid: isInvalid,
          isDisabled: disabled,
          clear: isClearable ? {
            onClick: _this3.onClear,
            'aria-label': clearSearchButtonLabel,
            'data-test-subj': 'clearSearchButton'
          } : undefined,
          compressed: compressed,
          append: append,
          prepend: prepend
        }, ___EmotionJSX(EuiValidatableControl, {
          isInvalid: isInvalid
        }, ___EmotionJSX("input", _extends({
          type: "search",
          id: id,
          name: name,
          placeholder: placeholder,
          className: classes,
          css: cssStyles,
          onKeyUp: function onKeyUp(e) {
            return _this3.onKeyUp(e, incremental, onSearch);
          },
          disabled: disabled,
          ref: _this3.setRef
        }, rest))));
      });
    }
  }]);
}(Component);
_defineProperty(EuiFieldSearchClass, "contextType", FormContext);
_defineProperty(EuiFieldSearchClass, "defaultProps", {
  isLoading: false,
  incremental: false,
  compressed: false,
  isClearable: true
});
export var EuiFieldSearch = withEuiStylesMemoizer(EuiFieldSearchClass);