import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["id", "name", "placeholder", "value", "className", "icon", "isInvalid", "inputRef", "fullWidth", "isLoading", "compressed", "prepend", "append", "readOnly", "controlOnly"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiFormControlLayout } from '../form_control_layout';
import { EuiValidatableControl } from '../validatable_control';
import { useFormContext } from '../eui_form_context';
import { euiFieldTextStyles } from './field_text.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFieldText = function EuiFieldText(props) {
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var id = props.id,
    name = props.name,
    placeholder = props.placeholder,
    value = props.value,
    className = props.className,
    icon = props.icon,
    isInvalid = props.isInvalid,
    inputRef = props.inputRef,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    isLoading = props.isLoading,
    compressed = props.compressed,
    prepend = props.prepend,
    append = props.append,
    readOnly = props.readOnly,
    controlOnly = props.controlOnly,
    rest = _objectWithoutProperties(props, _excluded);
  var classes = classNames('euiFieldText', className, {
    'euiFieldText-isLoading': isLoading
  });
  var styles = useEuiMemoizedStyles(euiFieldTextStyles);
  var cssStyles = [styles.euiFieldText, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, !controlOnly && (prepend || append) && styles.inGroup, controlOnly && styles.controlOnly];
  var control = ___EmotionJSX(EuiValidatableControl, {
    isInvalid: isInvalid
  }, ___EmotionJSX("input", _extends({
    type: "text",
    id: id,
    name: name,
    placeholder: placeholder,
    className: classes,
    css: cssStyles,
    value: value,
    ref: inputRef,
    readOnly: readOnly
  }, rest)));
  if (controlOnly) return control;
  return ___EmotionJSX(EuiFormControlLayout, {
    icon: icon,
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: rest.disabled,
    compressed: compressed,
    readOnly: readOnly,
    prepend: prepend,
    append: append,
    inputId: id
  }, control);
};