import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["stylesMemoizer", "id", "name", "initialPromptText", "className", "disabled", "compressed", "onChange", "isInvalid", "fullWidth", "isLoading", "display"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import classNames from 'classnames';
import { withEuiStylesMemoizer, htmlIdGenerator } from '../../../services';
import { EuiButtonEmpty } from '../../button';
import { EuiProgress } from '../../progress';
import { EuiIcon } from '../../icon';
import { EuiI18n } from '../../i18n';
import { EuiLoadingSpinner } from '../../loading';
import { FormContext } from '../eui_form_context';
import { EuiValidatableControl } from '../validatable_control';
import { EuiFormControlLayoutClearButton } from '../form_control_layout/form_control_layout_clear_button';
import { euiFilePickerStyles } from './file_picker.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFilePickerClass = /*#__PURE__*/function (_Component) {
  function EuiFilePickerClass() {
    var _this;
    _classCallCheck(this, EuiFilePickerClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiFilePickerClass, [].concat(args));
    _defineProperty(_this, "state", {
      promptText: null,
      isHoveringDrop: false
    });
    _defineProperty(_this, "fileInput", null);
    _defineProperty(_this, "generatedId", htmlIdGenerator()());
    _defineProperty(_this, "handleChange", function () {
      if (!_this.fileInput) return;
      if (_this.fileInput.files && _this.fileInput.files.length > 1) {
        _this.setState({
          promptText: ___EmotionJSX(EuiI18n, {
            token: "euiFilePicker.filesSelected",
            default: "{fileCount} files selected",
            values: {
              fileCount: _this.fileInput.files.length
            }
          })
        });
      } else if (_this.fileInput.files && _this.fileInput.files.length === 0) {
        _this.setState({
          promptText: null
        });
      } else {
        _this.setState({
          promptText: _this.fileInput.value.split('\\').pop()
        });
      }
      var onChange = _this.props.onChange;
      if (onChange) {
        onChange(_this.fileInput.files);
      }
    });
    _defineProperty(_this, "removeFiles", function (e) {
      if (e) {
        e.stopPropagation();
        e.preventDefault();
      }
      if (!_this.fileInput) return;
      _this.fileInput.value = '';
      _this.handleChange();
    });
    _defineProperty(_this, "showDrop", function () {
      if (!_this.props.disabled) {
        _this.setState({
          isHoveringDrop: true
        });
      }
    });
    _defineProperty(_this, "hideDrop", function () {
      _this.setState({
        isHoveringDrop: false
      });
    });
    return _this;
  }
  _inherits(EuiFilePickerClass, _Component);
  return _createClass(EuiFilePickerClass, [{
    key: "render",
    value: function render() {
      var _this2 = this;
      var _ref = this.context,
        defaultFullWidth = _ref.defaultFullWidth;
      return ___EmotionJSX(EuiI18n, {
        token: "euiFilePicker.removeSelectedAriaLabel",
        default: "Remove selected files"
      }, function (removeSelectedAriaLabel) {
        var _this2$props = _this2.props,
          stylesMemoizer = _this2$props.stylesMemoizer,
          id = _this2$props.id,
          name = _this2$props.name,
          initialPromptText = _this2$props.initialPromptText,
          className = _this2$props.className,
          disabled = _this2$props.disabled,
          compressed = _this2$props.compressed,
          onChange = _this2$props.onChange,
          isInvalid = _this2$props.isInvalid,
          _this2$props$fullWidt = _this2$props.fullWidth,
          fullWidth = _this2$props$fullWidt === void 0 ? defaultFullWidth : _this2$props$fullWidt,
          isLoading = _this2$props.isLoading,
          display = _this2$props.display,
          rest = _objectWithoutProperties(_this2$props, _excluded);
        var promptId = "".concat(id || _this2.generatedId, "-filePicker__prompt");
        var isOverridingInitialPrompt = _this2.state.promptText != null;
        var normalFormControl = display === 'default';
        var classes = classNames('euiFilePicker', {
          'euiFilePicker-isDroppingFile': _this2.state.isHoveringDrop,
          'euiFilePicker-isInvalid': isInvalid,
          'euiFilePicker-isLoading': isLoading,
          'euiFilePicker-hasFiles': isOverridingInitialPrompt
        }, className);
        var styles = stylesMemoizer(euiFilePickerStyles);
        var cssStyles = [styles.euiFilePicker, fullWidth ? styles.fullWidth : styles.formWidth, _this2.state.isHoveringDrop && styles.isDroppingFile, isInvalid && !disabled && styles.invalid, isOverridingInitialPrompt && !disabled && styles.hasFiles, isLoading && styles.loading];
        var inputStyles = [styles.input.euiFilePicker__input, !normalFormControl && !disabled && styles.input.largeInteractive];
        var promptStyles = [styles.euiFilePicker__prompt, disabled && styles.disabled].concat(_toConsumableArray(normalFormControl ? [compressed ? styles.compressed : styles.uncompressed] : [styles.large.large, compressed ? styles.large.compressed : styles.large.uncompressed]));
        var iconStyles = [styles.icon.euiFilePicker__icon].concat(_toConsumableArray(normalFormControl ? [styles.icon.normal, compressed ? styles.icon.compresssed : styles.icon.uncompressed] : [styles.icon.large]));
        var rightIconStyles = normalFormControl ? [styles.rightIcon.euiFilePicker__rightIcon, compressed ? styles.rightIcon.compressed : styles.rightIcon.uncompressed] : undefined;
        var clearButton;
        if (isLoading && normalFormControl) {
          // Override clear button with loading spinner if it is in loading state
          clearButton = ___EmotionJSX(EuiLoadingSpinner, {
            css: rightIconStyles,
            className: "euiFilePicker__loadingSpinner",
            size: compressed ? 's' : 'm'
          });
        } else if (isOverridingInitialPrompt && !disabled) {
          if (normalFormControl) {
            clearButton = ___EmotionJSX(EuiFormControlLayoutClearButton, {
              "aria-label": removeSelectedAriaLabel,
              css: [styles.euiFilePicker__clearButton, rightIconStyles, ";label:clearButton;"],
              className: "euiFilePicker__clearButton",
              onClick: _this2.removeFiles,
              size: compressed ? 's' : 'm'
            });
          } else {
            clearButton = ___EmotionJSX(EuiButtonEmpty, {
              "aria-label": removeSelectedAriaLabel,
              css: styles.euiFilePicker__clearButton,
              className: "euiFilePicker__clearButton",
              size: "xs",
              onClick: _this2.removeFiles
            }, ___EmotionJSX(EuiI18n, {
              token: "euiFilePicker.removeSelected",
              default: "Remove"
            }));
          }
        } else {
          clearButton = null;
        }
        var loader = !normalFormControl && isLoading && ___EmotionJSX(EuiProgress, {
          size: "xs",
          color: "accent",
          position: "absolute"
        });
        return ___EmotionJSX("div", {
          css: cssStyles,
          className: classes
        }, ___EmotionJSX(EuiValidatableControl, {
          isInvalid: isInvalid
        }, ___EmotionJSX("input", _extends({
          type: "file",
          id: id,
          name: name,
          css: inputStyles,
          className: "euiFilePicker__input",
          onChange: _this2.handleChange,
          ref: function ref(input) {
            _this2.fileInput = input;
          },
          onDragOver: _this2.showDrop,
          onDragLeave: _this2.hideDrop,
          onDrop: _this2.hideDrop,
          disabled: disabled,
          "aria-describedby": promptId
        }, rest))), ___EmotionJSX("div", {
          css: promptStyles,
          className: "euiFilePicker__prompt",
          id: promptId
        }, ___EmotionJSX(EuiIcon, {
          css: iconStyles,
          className: "euiFilePicker__icon",
          color: isInvalid ? 'danger' : disabled ? 'subdued' : 'primary',
          type: isInvalid ? 'alert' : 'importAction',
          size: normalFormControl ? 'm' : 'l',
          "aria-hidden": "true"
        }), ___EmotionJSX("span", {
          className: "euiFilePicker__promptText"
        }, _this2.state.promptText || initialPromptText), clearButton, loader));
      });
    }
  }]);
}(Component);
_defineProperty(EuiFilePickerClass, "contextType", FormContext);
_defineProperty(EuiFilePickerClass, "defaultProps", {
  initialPromptText: ___EmotionJSX(EuiI18n, {
    token: "euiFilePicker.promptText",
    default: "Select or drag and drop a file"
  }),
  compressed: false,
  display: 'large'
});
export var EuiFilePicker = withEuiStylesMemoizer(EuiFilePickerClass);