import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "isInvalid", "error", "component", "invalidCallout", "fullWidth"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo, forwardRef } from 'react';
import classNames from 'classnames';
import { EuiCallOut } from '../call_out';
import { EuiI18n } from '../i18n';
import { EuiSpacer } from '../spacer';
import { FormContext } from './eui_form_context';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiForm = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    className = _ref.className,
    isInvalid = _ref.isInvalid,
    error = _ref.error,
    _ref$component = _ref.component,
    component = _ref$component === void 0 ? 'div' : _ref$component,
    _ref$invalidCallout = _ref.invalidCallout,
    invalidCallout = _ref$invalidCallout === void 0 ? 'above' : _ref$invalidCallout,
    fullWidth = _ref.fullWidth,
    rest = _objectWithoutProperties(_ref, _excluded);
  var formContext = useMemo(function () {
    return {
      defaultFullWidth: fullWidth !== null && fullWidth !== void 0 ? fullWidth : false
    };
  }, [fullWidth]);
  var handleFocus = useCallback(function (node) {
    node === null || node === void 0 || node.focus();
  }, []);
  var classes = classNames('euiForm', className);
  var optionalErrors = null;
  if (error) {
    var errorTexts = Array.isArray(error) ? error : [error];
    optionalErrors = ___EmotionJSX("ul", null, errorTexts.map(function (error, index) {
      return ___EmotionJSX("li", {
        className: "euiForm__error",
        key: index
      }, error);
    }));
  }
  var optionalErrorAlert;
  if (isInvalid && invalidCallout === 'above') {
    optionalErrorAlert = ___EmotionJSX(EuiI18n, {
      token: "euiForm.addressFormErrors",
      default: "Please address the highlighted errors."
    }, function (addressFormErrors) {
      return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiCallOut, {
        tabIndex: -1,
        ref: handleFocus,
        className: "euiForm__errors",
        title: addressFormErrors,
        color: "danger",
        role: "alert",
        "aria-live": "assertive"
      }, optionalErrors), ___EmotionJSX(EuiSpacer, {
        size: "m"
      }));
    });
  }
  var Element = component;
  return ___EmotionJSX(Element
  // @ts-expect-error Element is a <div> or <form>, but TypeScript wants to support both
  , _extends({
    ref: ref,
    className: classes
  }, rest), ___EmotionJSX(FormContext.Provider, {
    value: formContext
  }, optionalErrorAlert, children));
});
EuiForm.displayName = 'EuiForm';