import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { shade, tint, darken, transparentize, makeHighContrastColor } from '../../services';
import { logicalCSS, mathWithUnits, euiCanAnimate, euiFontSize } from '../../global_styling';
import { euiButtonColor } from '../../themes/amsterdam/global_styling/mixins';

// There are multiple components that only need the form max-width size &
// don't need the extra overhead/color computing expense of every form var.
// For microperf, we're making this its own util
export var euiFormMaxWidth = function euiFormMaxWidth(_ref) {
  var euiTheme = _ref.euiTheme;
  return mathWithUnits(euiTheme.size.base, function (x) {
    return x * 25;
  });
};
export var euiFormVariables = function euiFormVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var isColorDark = colorMode === 'DARK';
  var backgroundColor = isColorDark ? shade(euiTheme.colors.lightestShade, 0.4) : tint(euiTheme.colors.lightestShade, 0.6);
  var controlHeight = euiTheme.size.xxl;
  var controlCompressedHeight = euiTheme.size.xl;
  var sizes = {
    maxWidth: euiFormMaxWidth(euiThemeContext),
    controlHeight: controlHeight,
    controlCompressedHeight: controlCompressedHeight,
    controlPadding: euiTheme.size.m,
    controlCompressedPadding: euiTheme.size.s,
    controlBorderRadius: euiTheme.border.radius.medium,
    controlCompressedBorderRadius: euiTheme.border.radius.small,
    iconAffordance: mathWithUnits(euiTheme.size.base, function (x) {
      return x * 1.5;
    }),
    iconCompressedAffordance: mathWithUnits(euiTheme.size.m, function (x) {
      return x * 1.5;
    })
  };
  var colors = {
    textColor: euiTheme.colors.text,
    backgroundColor: backgroundColor,
    backgroundDisabledColor: darken(euiTheme.colors.lightestShade, 0.05),
    backgroundReadOnlyColor: euiTheme.colors.emptyShade,
    borderColor: transparentize(colorMode === 'DARK' ? euiTheme.colors.ghost : darken(euiTheme.border.color, 4), 0.1),
    controlDisabledColor: euiTheme.colors.mediumShade,
    controlBoxShadow: '0 0 transparent',
    controlPlaceholderText: makeHighContrastColor(euiTheme.colors.subduedText)(backgroundColor),
    appendPrependBackground: isColorDark ? shade(euiTheme.colors.lightShade, 0.15) : tint(euiTheme.colors.lightShade, 0.5)
  };
  var controlLayout = {
    controlLayoutGroupInputHeight: mathWithUnits(controlHeight, function (x) {
      return x - 2;
    }),
    controlLayoutGroupInputCompressedHeight: mathWithUnits(controlCompressedHeight, function (x) {
      return x - 2;
    }),
    controlLayoutGroupInputCompressedBorderRadius: euiTheme.border.radius.small
  };
  var iconSizes = {
    controlIconSize: {
      s: euiTheme.size.m,
      m: euiTheme.size.base,
      l: euiTheme.size.l,
      xl: euiTheme.size.xl,
      xxl: euiTheme.size.xxl
    }
  };
  return _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, sizes), colors), iconSizes), controlLayout), {}, {
    animationTiming: "".concat(euiTheme.animation.fast, " ease-in")
  });
};
export var euiFormControlStyles = function euiFormControlStyles(euiThemeContext) {
  var form = euiFormVariables(euiThemeContext);
  return {
    shared: "\n      ".concat(euiFormControlText(euiThemeContext), "\n      ").concat(euiFormControlDefaultShadow(euiThemeContext), "\n    "),
    // Sizes
    uncompressed: "\n      ".concat(logicalCSS('height', form.controlHeight), "\n      ").concat(logicalCSS('padding-vertical', form.controlPadding), "\n      ").concat(logicalCSS('padding-left', "calc(".concat(form.controlPadding, " + (").concat(form.iconAffordance, " * var(--euiFormControlLeftIconsCount, 0)))")), "\n      ").concat(logicalCSS('padding-right', "calc(".concat(form.controlPadding, " + (").concat(form.iconAffordance, " * var(--euiFormControlRightIconsCount, 0)))")), "\n      border-radius: ").concat(form.controlBorderRadius, ";\n    "),
    compressed: "\n      ".concat(logicalCSS('height', form.controlCompressedHeight), "\n      ").concat(logicalCSS('padding-vertical', form.controlCompressedPadding), "\n      ").concat(logicalCSS('padding-left', "calc(".concat(form.controlCompressedPadding, " + (").concat(form.iconCompressedAffordance, " * var(--euiFormControlLeftIconsCount, 0)))")), "\n      ").concat(logicalCSS('padding-right', "calc(".concat(form.controlCompressedPadding, " + (").concat(form.iconCompressedAffordance, " * var(--euiFormControlRightIconsCount, 0)))")), "\n      border-radius: ").concat(form.controlCompressedBorderRadius, ";\n    "),
    // In group
    inGroup: "\n      ".concat(logicalCSS('height', '100%'), "\n      box-shadow: none;\n      border-radius: 0;\n    "),
    // Widths
    formWidth: "\n      ".concat(logicalCSS('max-width', form.maxWidth), "\n      ").concat(logicalCSS('width', '100%'), "\n    "),
    fullWidth: "\n      ".concat(logicalCSS('max-width', '100%'), "\n      ").concat(logicalCSS('width', '100%'), "\n    "),
    // States
    invalid: euiFormControlInvalidStyles(euiThemeContext),
    focus: euiFormControlFocusStyles(euiThemeContext),
    disabled: euiFormControlDisabledStyles(euiThemeContext),
    readOnly: euiFormControlReadOnlyStyles(euiThemeContext),
    autoFill: euiFormControlAutoFillStyles(euiThemeContext)
  };
};
export var euiFormControlText = function euiFormControlText(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFontSize = euiFontSize(euiThemeContext, 's'),
    fontSize = _euiFontSize.fontSize;
  var form = euiFormVariables(euiThemeContext);
  return "\n    font-family: ".concat(euiTheme.font.family, ";\n    font-size: ").concat(fontSize, ";\n    color: ").concat(form.textColor, ";\n\n    ").concat(euiPlaceholderPerBrowser("\n      color: ".concat(form.controlPlaceholderText, ";\n      opacity: 1;\n    ")), "\n  ");
};
export var euiFormControlDefaultShadow = function euiFormControlDefaultShadow(euiThemeContext) {
  var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    _ref2$withBorder = _ref2.withBorder,
    withBorder = _ref2$withBorder === void 0 ? true : _ref2$withBorder,
    _ref2$withBackground = _ref2.withBackground,
    withBackground = _ref2$withBackground === void 0 ? true : _ref2$withBackground,
    _ref2$withBackgroundC = _ref2.withBackgroundColor,
    withBackgroundColor = _ref2$withBackgroundC === void 0 ? withBackground : _ref2$withBackgroundC,
    _ref2$withBackgroundA = _ref2.withBackgroundAnimation,
    withBackgroundAnimation = _ref2$withBackgroundA === void 0 ? withBackground : _ref2$withBackgroundA;
  var euiTheme = euiThemeContext.euiTheme;
  var form = euiFormVariables(euiThemeContext);

  // We use inset box-shadow instead of border to skip extra height calculations
  var border = "\n    border: none;\n    box-shadow: inset 0 0 0 ".concat(euiTheme.border.width.thin, " ").concat(form.borderColor, ";\n  ").trim();
  var backgroundColor = "\n    background-color: ".concat(form.backgroundColor, ";\n  ").trim();
  var backgroundGradient = "\n    background-repeat: no-repeat;\n    background-size: 0% 100%;\n    background-image: linear-gradient(to top,\n      var(--euiFormControlStateColor),\n      var(--euiFormControlStateColor) ".concat(euiTheme.border.width.thick, ",\n      transparent ").concat(euiTheme.border.width.thick, ",\n      transparent 100%\n    );\n  ").trim();
  var backgroundAnimation = "\n    ".concat(euiCanAnimate, " {\n      transition:\n        background-image ").concat(form.animationTiming, ",\n        background-size ").concat(form.animationTiming, ",\n        background-color ").concat(form.animationTiming, ";\n    }\n  ").trim();
  return "\n    ".concat(withBorder ? border : '', "\n    ").concat(withBackgroundColor ? backgroundColor : '', "\n    ").concat(withBackground ? backgroundGradient : '', "\n    ").concat(withBackgroundAnimation ? backgroundAnimation : '', "\n  ");
};
export var euiFormControlFocusStyles = function euiFormControlFocusStyles(_ref3) {
  var euiTheme = _ref3.euiTheme,
    colorMode = _ref3.colorMode;
  return "\n  --euiFormControlStateColor: ".concat(euiTheme.colors.primary, ";\n  background-color: ").concat(colorMode === 'DARK' ? shade(euiTheme.colors.emptyShade, 0.4) : euiTheme.colors.emptyShade, ";\n  background-size: 100% 100%;\n  outline: none; /* Remove all outlines and rely on our own bottom border gradient */\n");
};
export var euiFormControlInvalidStyles = function euiFormControlInvalidStyles(_ref4) {
  var euiTheme = _ref4.euiTheme;
  return "\n  --euiFormControlStateColor: ".concat(euiTheme.colors.danger, ";\n  background-size: 100% 100%;\n");
};
export var euiFormControlDisabledStyles = function euiFormControlDisabledStyles(euiThemeContext) {
  var form = euiFormVariables(euiThemeContext);
  return "\n    color: ".concat(form.controlDisabledColor, ";\n    /* Required for Safari */\n    -webkit-text-fill-color: ").concat(form.controlDisabledColor, ";\n    background-color: ").concat(form.backgroundDisabledColor, ";\n    cursor: not-allowed;\n    --euiFormControlStateColor: transparent;\n\n    ").concat(euiPlaceholderPerBrowser("\n      color: ".concat(form.controlDisabledColor, ";\n      opacity: 1;\n    ")), "\n  ");
};
export var euiFormControlReadOnlyStyles = function euiFormControlReadOnlyStyles(euiThemeContext) {
  var form = euiFormVariables(euiThemeContext);
  return "\n    cursor: default;\n    color: ".concat(form.textColor, ";\n    -webkit-text-fill-color: ").concat(form.textColor, "; /* Required for Safari */\n\n    background-color: ").concat(form.backgroundReadOnlyColor, ";\n    --euiFormControlStateColor: transparent;\n  ");
};
export var euiFormControlAutoFillStyles = function euiFormControlAutoFillStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;

  // Make the text color slightly less prominent than the default colors.text
  var textColor = euiTheme.colors.darkestShade;
  var _euiButtonColor = euiButtonColor(euiThemeContext, 'primary'),
    backgroundColor = _euiButtonColor.backgroundColor;
  var tintedBackgroundColor = colorMode === 'DARK' ? shade(backgroundColor, 0.5) : tint(backgroundColor, 0.7);
  // Hacky workaround to background-color, since Chrome doesn't normally allow overriding its styles
  // @see https://developer.mozilla.org/en-US/docs/Web/CSS/:autofill#sect1
  var backgroundShadow = "inset 0 0 0 100vw ".concat(tintedBackgroundColor);

  // Re-create the border, since the above webkit box shadow overrides the default border box-shadow
  // + change the border color to match states, since the underline background gradient no longer works
  var borderColor = transparentize(euiTheme.colors.primaryText, 0.2);
  var invalidBorder = euiTheme.colors.danger;
  var borderShadow = function borderShadow(color) {
    return "inset 0 0 0 ".concat(euiTheme.border.width.thin, " ").concat(color);
  };

  // These styles only apply/override Chrome/webkit browsers - Firefox does not set autofill styles
  return "\n    &:-webkit-autofill {\n      -webkit-text-fill-color: ".concat(textColor, ";\n      -webkit-box-shadow: ").concat(borderShadow(borderColor), ", ").concat(backgroundShadow, ";\n\n      &:invalid {\n        -webkit-box-shadow: ").concat(borderShadow(invalidBorder), ", ").concat(backgroundShadow, ";\n      }\n    }\n  ");
};
var euiPlaceholderPerBrowser = function euiPlaceholderPerBrowser(content) {
  return "\n  &::-webkit-input-placeholder { ".concat(content, " }\n  &::-moz-placeholder { ").concat(content, " }\n  &:-ms-input-placeholder { ").concat(content, " }\n  &:-moz-placeholder { ").concat(content, " }\n  &::placeholder { ").concat(content, " }\n");
};

/**
 * Selection custom controls - checkboxes, radios, and switches
 */

export var euiFormCustomControlVariables = function euiFormCustomControlVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var sizes = {
    control: euiTheme.size.base,
    lineHeight: euiTheme.size.l,
    labelGap: euiTheme.size.s
  };
  var colors = {
    unselected: euiTheme.colors.emptyShade,
    unselectedBorder: colorMode === 'DARK' ? tint(euiTheme.colors.lightestShade, 0.31) // WCAG AA requirements
    : shade(euiTheme.colors.lightestShade, 0.4),
    selected: euiTheme.colors.primary,
    selectedIcon: euiTheme.colors.emptyShade,
    disabled: euiTheme.colors.lightShade,
    disabledIcon: euiTheme.colors.darkShade,
    disabledLabel: euiTheme.colors.disabledText // Lighter than formVars.disabledColor because it typically doesn't have as dark a background
  };
  var animation = {
    speed: euiTheme.animation.fast,
    easing: 'ease-in'
  };
  return {
    sizes: sizes,
    colors: colors,
    animation: animation
  };
};
export var euiFormCustomControlStyles = function euiFormCustomControlStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var controlVars = euiFormCustomControlVariables(euiThemeContext);
  var centerWithLabel = mathWithUnits([controlVars.sizes.lineHeight, controlVars.sizes.control], function (x, y) {
    return (x - y) / 2;
  });
  return {
    wrapper: "\n      display: flex;\n      align-items: flex-start;\n    ",
    input: {
      fauxInput: "\n        position: relative;\n        ".concat(logicalCSS('height', controlVars.sizes.control), "\n        ").concat(logicalCSS('width', controlVars.sizes.control), "\n        display: flex;\n        justify-content: center;\n        align-items: center;\n\n        &:has(input:focus-visible) {\n          outline: ").concat(euiTheme.focus.width, " solid ").concat(controlVars.colors.selected, ";\n          outline-offset: ").concat(euiTheme.focus.width, ";\n        }\n\n        ").concat(euiCanAnimate, " {\n          transition-property: background-color, color;\n          transition-duration: ").concat(controlVars.animation.speed, ";\n          transition-timing-function: ").concat(controlVars.animation.easing, ";\n        }\n      "),
      // TODO: Revert https://github.com/elastic/eui/pull/7981
      // once https://github.com/dperini/nwsapi/issues/123
      // has been fixed, and restore `&:has(+ label)` selector
      hasLabel: "\n        ".concat(logicalCSS('margin-top', centerWithLabel), "\n      "),
      enabled: {
        selected: "\n          color: ".concat(controlVars.colors.selectedIcon, ";\n          background-color: ").concat(controlVars.colors.selected, ";\n        "),
        unselected: "\n          color: transparent;\n          background-color: ".concat(controlVars.colors.unselected, ";\n          border: ").concat(euiTheme.border.width.thin, " solid ").concat(controlVars.colors.unselectedBorder, ";\n\n          &:has(input:focus) {\n            border-color: ").concat(controlVars.colors.selected, ";\n          }\n        ")
      },
      disabled: {
        selected: "\n          label: disabled;\n          color: ".concat(controlVars.colors.disabledIcon, ";\n          background-color: ").concat(controlVars.colors.disabled, ";\n        "),
        unselected: "\n          label: disabled;\n          color: ".concat(controlVars.colors.disabled, ";\n          background-color: ").concat(controlVars.colors.disabled, ";\n          cursor: not-allowed;\n        ")
      },
      // Looks better centered at different zoom levels than just <EuiIcon size="s" />
      icon: "\n        transform: scale(0.75);\n      ",
      // Hidden input sits on top of the visible element
      hiddenInput: "\n        position: absolute;\n        inset: 0;\n        opacity: 0 !important;\n        cursor: pointer;\n\n        &:disabled {\n          cursor: not-allowed;\n        }\n      "
    },
    label: {
      label: "\n        /* Needs to use padding and not flex gap for extra mouse click area */\n        ".concat(logicalCSS('padding-left', controlVars.sizes.labelGap), "\n        line-height: ").concat(controlVars.sizes.lineHeight, ";\n        font-size: ").concat(euiFontSize(euiThemeContext, 's').fontSize, ";\n      "),
      enabled: "\n        cursor: pointer;\n      ",
      disabled: "\n        cursor: not-allowed;\n        color: ".concat(controlVars.colors.disabledLabel, ";\n      ")
    }
  };
};