import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { isIconShape } from './form_control_layout_icons';
export var isRightSideIcon = function isRightSideIcon(icon) {
  return !!icon && isIconShape(icon) && icon.side === 'right';
};
export var getIconAffordanceStyles = function getIconAffordanceStyles(_ref) {
  var icon = _ref.icon,
    clear = _ref.clear,
    isLoading = _ref.isLoading,
    isInvalid = _ref.isInvalid,
    isDropdown = _ref.isDropdown;
  var cssVariables = {
    '--euiFormControlLeftIconsCount': 0,
    '--euiFormControlRightIconsCount': 0
  };
  if (icon) {
    if (isRightSideIcon(icon)) {
      cssVariables['--euiFormControlRightIconsCount']++;
    } else {
      cssVariables['--euiFormControlLeftIconsCount']++;
    }
  }
  if (clear) cssVariables['--euiFormControlRightIconsCount']++;
  if (isLoading) cssVariables['--euiFormControlRightIconsCount']++;
  if (isInvalid) cssVariables['--euiFormControlRightIconsCount']++;
  if (isDropdown) cssVariables['--euiFormControlRightIconsCount']++;
  var filtered = Object.entries(cssVariables).filter(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      count = _ref3[1];
    return count > 0;
  });
  return filtered.length ? Object.fromEntries(filtered) : undefined;
};