import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["inputId", "className", "children", "icon", "iconsPosition", "clear", "isDropdown", "isLoading", "isInvalid", "isDisabled", "readOnly", "compressed", "prepend", "append", "isDelimited", "wrapperProps", "fullWidth"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiFormLabel } from '../form_label';
import { useFormContext } from '../eui_form_context';
import { getIconAffordanceStyles, isRightSideIcon } from './_num_icons';
import { EuiFormControlLayoutIcons } from './form_control_layout_icons';
import { euiFormControlLayoutStyles, euiFormControlLayoutSideNodeStyles } from './form_control_layout.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFormControlLayout = function EuiFormControlLayout(props) {
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var inputId = props.inputId,
    className = props.className,
    children = props.children,
    icon = props.icon,
    _props$iconsPosition = props.iconsPosition,
    iconsPosition = _props$iconsPosition === void 0 ? 'absolute' : _props$iconsPosition,
    clear = props.clear,
    isDropdown = props.isDropdown,
    isLoading = props.isLoading,
    isInvalid = props.isInvalid,
    isDisabled = props.isDisabled,
    readOnly = props.readOnly,
    compressed = props.compressed,
    prepend = props.prepend,
    append = props.append,
    isDelimited = props.isDelimited,
    wrapperProps = props.wrapperProps,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    rest = _objectWithoutProperties(props, _excluded);
  var isGroup = !!(prepend || append || isDelimited);
  var classes = classNames('euiFormControlLayout', {
    'euiFormControlLayout--group': isGroup && !isDelimited,
    'euiFormControlLayout-isDisabled': isDisabled,
    'euiFormControlLayout-readOnly': readOnly
  }, className);
  var styles = useEuiMemoizedStyles(euiFormControlLayoutStyles);
  var cssStyles = [styles.euiFormControlLayout, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth].concat(_toConsumableArray(isGroup ? [styles.group.group, compressed ? styles.group.compressed : styles.group.uncompressed] : []));
  var childrenWrapperStyles = [styles.children.euiFormControlLayout__childrenWrapper, isGroup && styles.children.inGroup, isGroup && !append && styles.children.prependOnly, isGroup && !prepend && styles.children.appendOnly, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  var hasDropdownIcon = !readOnly && !isDisabled && isDropdown;
  var hasRightIcon = isRightSideIcon(icon);
  var hasLeftIcon = icon && !hasRightIcon;
  var hasRightIcons = hasRightIcon || clear || isLoading || isInvalid || hasDropdownIcon;
  var iconAffordanceStyles = useMemo(function () {
    if (iconsPosition === 'static') return; // Static icons don't need padding affordance

    return getIconAffordanceStyles({
      icon: icon,
      clear: clear,
      isInvalid: isInvalid,
      isLoading: isLoading,
      isDropdown: hasDropdownIcon
    });
  }, [iconsPosition, icon, clear, isInvalid, isLoading, hasDropdownIcon]);
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), ___EmotionJSX(EuiFormControlLayoutSideNodes, {
    side: "prepend",
    nodes: prepend,
    inputId: inputId,
    compressed: compressed
  }), ___EmotionJSX("div", _extends({}, wrapperProps, {
    css: childrenWrapperStyles,
    className: classNames('euiFormControlLayout__childrenWrapper', wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.className),
    style: _objectSpread(_objectSpread({}, iconAffordanceStyles), wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.style)
  }), hasLeftIcon && ___EmotionJSX(EuiFormControlLayoutIcons, {
    side: "left",
    icon: icon,
    iconsPosition: iconsPosition,
    compressed: compressed,
    isDisabled: isDisabled
  }), children, hasRightIcons && ___EmotionJSX(EuiFormControlLayoutIcons, {
    side: "right",
    icon: hasRightIcon ? icon : undefined,
    iconsPosition: iconsPosition,
    compressed: compressed,
    clear: clear,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDropdown: hasDropdownIcon,
    isDisabled: isDisabled
  })), ___EmotionJSX(EuiFormControlLayoutSideNodes, {
    side: "append",
    nodes: append,
    inputId: inputId,
    compressed: compressed
  }));
};

/**
 * Internal subcomponent utility for prepend/append nodes
 */
var EuiFormControlLayoutSideNodes = function EuiFormControlLayoutSideNodes(_ref) {
  var side = _ref.side,
    nodes = _ref.nodes,
    inputId = _ref.inputId,
    compressed = _ref.compressed;
  var className = "euiFormControlLayout__".concat(side);
  var styles = useEuiMemoizedStyles(euiFormControlLayoutSideNodeStyles);
  var cssStyles = [styles.euiFormControlLayout__side, styles[side], compressed ? styles.compressed : styles.uncompressed];
  if (!nodes) return null;
  return ___EmotionJSX("div", {
    css: cssStyles,
    className: className
  }, React.Children.map(nodes, function (node) {
    return typeof node === 'string' ? ___EmotionJSX(EuiFormLabel, {
      htmlFor: inputId
    }, node) : node;
  }));
};