import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "onClick", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiIcon } from '../../icon';
import { useEuiI18n } from '../../i18n';
import { EuiFormControlLayoutClearButtonStyles } from './form_control_layout_clear_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFormControlLayoutClearButton = function EuiFormControlLayoutClearButton(_ref) {
  var className = _ref.className,
    onClick = _ref.onClick,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiFormControlLayoutClearButton', className);
  var styles = useEuiMemoizedStyles(EuiFormControlLayoutClearButtonStyles);
  var iconStyles = [styles.euiFormControlLayoutClearButton__icon, styles.size[size]];
  var ariaLabel = useEuiI18n('euiFormControlLayoutClearButton.label', 'Clear input');
  return ___EmotionJSX("button", _extends({
    type: "button",
    css: styles.euiFormControlLayoutClearButton,
    className: classes,
    onClick: onClick,
    "aria-label": ariaLabel
  }, rest), ___EmotionJSX(EuiIcon, {
    css: iconStyles,
    className: "euiFormControlLayoutClearButton__icon",
    type: "cross",
    size: size
  }));
};