import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "onClick", "type", "iconRef", "size", "color", "disabled"];
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import { css } from '@emotion/react';
import classNames from 'classnames';
import { EuiIcon } from '../../icon';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiFormControlLayoutCustomIcon = function EuiFormControlLayoutCustomIcon(_ref) {
  var className = _ref.className,
    onClick = _ref.onClick,
    type = _ref.type,
    iconRef = _ref.iconRef,
    size = _ref.size,
    color = _ref.color,
    disabled = _ref.disabled,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiFormControlLayoutCustomIcon', className);
  var cssStyles = [styles.euiFormControlLayoutCustomIcon, onClick ? styles.clickable : styles.unclickable];
  if (onClick) {
    return ___EmotionJSX("button", _extends({
      type: "button",
      onClick: onClick,
      disabled: disabled,
      css: cssStyles,
      className: classes,
      ref: iconRef
    }, rest), ___EmotionJSX(EuiIcon, {
      className: "euiFormControlLayoutCustomIcon__icon",
      "aria-hidden": "true",
      size: size,
      type: type,
      color: color
    }));
  }
  return ___EmotionJSX("span", _extends({
    css: cssStyles,
    className: classes,
    ref: iconRef
  }, rest), ___EmotionJSX(EuiIcon, {
    className: "euiFormControlLayoutCustomIcon__icon",
    "aria-hidden": "true",
    size: size,
    type: type,
    color: color
  }));
};
var styles = {
  euiFormControlLayoutCustomIcon: process.env.NODE_ENV === "production" ? {
    name: "7d1ma8-euiFormControlLayoutCustomIcon",
    styles: "font-size:0;label:euiFormControlLayoutCustomIcon;"
  } : {
    name: "7d1ma8-euiFormControlLayoutCustomIcon",
    styles: "font-size:0;label:euiFormControlLayoutCustomIcon;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  },
  // Skip css`` here to avoid generating an Emotion className
  unclickable: "\n    pointer-events: none;\n  ",
  clickable: process.env.NODE_ENV === "production" ? {
    name: "1j8wgxj-clickable",
    styles: "pointer-events:all;&:disabled{cursor:not-allowed;color:currentColor;};label:clickable;"
  } : {
    name: "1j8wgxj-clickable",
    styles: "pointer-events:all;&:disabled{cursor:not-allowed;color:currentColor;};label:clickable;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};