import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
var _excluded = ["ref", "side"];
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component } from 'react';
import { RenderWithEuiStylesMemoizer } from '../../../services';
import { EuiIcon } from '../../icon';
import { EuiLoadingSpinner } from '../../loading';
import { EuiFormControlLayoutClearButton } from './form_control_layout_clear_button';
import { EuiFormControlLayoutCustomIcon } from './form_control_layout_custom_icon';
import { euiFormControlLayoutIconsStyles } from './form_control_layout_icons.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var ICON_SIDES = ['left', 'right'];
export var isIconShape = function isIconShape(icon) {
  return !!icon && icon.hasOwnProperty('type');
};
export var EuiFormControlLayoutIcons = /*#__PURE__*/function (_Component) {
  function EuiFormControlLayoutIcons() {
    _classCallCheck(this, EuiFormControlLayoutIcons);
    return _callSuper(this, EuiFormControlLayoutIcons, arguments);
  }
  _inherits(EuiFormControlLayoutIcons, _Component);
  return _createClass(EuiFormControlLayoutIcons, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        _this$props$side = _this$props.side,
        side = _this$props$side === void 0 ? 'left' : _this$props$side,
        _this$props$iconsPosi = _this$props.iconsPosition,
        iconsPosition = _this$props$iconsPosi === void 0 ? 'absolute' : _this$props$iconsPosi,
        compressed = _this$props.compressed,
        isDisabled = _this$props.isDisabled;
      var customIcon = this.renderCustomIcon();
      var loadingSpinner = this.renderLoadingSpinner();
      var clearButton = this.renderClearButton();
      var invalidIcon = this.renderInvalidIcon();
      var dropdownIcon = this.renderDropdownIcon();
      return ___EmotionJSX(RenderWithEuiStylesMemoizer, null, function (stylesMemoizer) {
        var styles = stylesMemoizer(euiFormControlLayoutIconsStyles);
        var cssStyles = [styles.euiFormControlLayoutIcons, compressed ? styles.compressed : styles.uncompressed].concat(_toConsumableArray(iconsPosition === 'absolute' ? [styles.position.absolute.absolute, compressed ? styles.position.absolute.compressed[side] : styles.position.absolute.uncompressed[side]] : [styles.position.static.static, compressed ? styles.position.static.compressed : styles.position.static.uncompressed]), [isDisabled && styles.disabled]);
        return ___EmotionJSX("div", {
          css: cssStyles,
          className: "euiFormControlLayoutIcons"
        }, clearButton, loadingSpinner, invalidIcon, customIcon, dropdownIcon);
      });
    }
  }, {
    key: "renderCustomIcon",
    value: function renderCustomIcon() {
      var _this$props2 = this.props,
        icon = _this$props2.icon,
        compressed = _this$props2.compressed,
        isDisabled = _this$props2.isDisabled;
      if (!icon) {
        return null;
      }

      // Normalize the icon to an object if it's a string.
      var iconProps = isIconShape(icon) ? icon : {
        type: icon
      };
      var iconRef = iconProps.ref,
        side = iconProps.side,
        iconRest = _objectWithoutProperties(iconProps, _excluded);
      return ___EmotionJSX(EuiFormControlLayoutCustomIcon, _extends({
        size: compressed ? 's' : 'm',
        disabled: isDisabled,
        iconRef: iconRef
      }, iconRest));
    }
  }, {
    key: "renderDropdownIcon",
    value: function renderDropdownIcon() {
      var _this$props3 = this.props,
        isDropdown = _this$props3.isDropdown,
        compressed = _this$props3.compressed,
        isDisabled = _this$props3.isDisabled;
      if (!isDropdown) {
        return null;
      }
      return ___EmotionJSX(EuiFormControlLayoutCustomIcon, {
        size: compressed ? 's' : 'm',
        disabled: isDisabled,
        type: "arrowDown"
      });
    }
  }, {
    key: "renderLoadingSpinner",
    value: function renderLoadingSpinner() {
      var _this$props4 = this.props,
        isLoading = _this$props4.isLoading,
        compressed = _this$props4.compressed;
      if (!isLoading) {
        return null;
      }
      return ___EmotionJSX(EuiLoadingSpinner, {
        size: compressed ? 's' : 'm'
      });
    }
  }, {
    key: "renderClearButton",
    value: function renderClearButton() {
      var _this$props5 = this.props,
        clear = _this$props5.clear,
        compressed = _this$props5.compressed,
        isDisabled = _this$props5.isDisabled;
      if (!clear) {
        return null;
      }
      return ___EmotionJSX(EuiFormControlLayoutClearButton, _extends({
        size: compressed ? 's' : 'm',
        disabled: isDisabled
      }, clear));
    }
  }, {
    key: "renderInvalidIcon",
    value: function renderInvalidIcon() {
      var _this$props6 = this.props,
        isInvalid = _this$props6.isInvalid,
        compressed = _this$props6.compressed;
      if (!isInvalid) {
        return null;
      }
      return ___EmotionJSX(EuiIcon, {
        size: compressed ? 's' : 'm',
        color: "danger",
        type: "warning"
      });
    }
  }]);
}(Component);